﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <map>
#include <vector>
#include "IoPortRecorder.h"
#include "IoPortSender.h"

class PythonCodeExporter
{
public:
    PythonCodeExporter();
    ~PythonCodeExporter();

    HidInputerResult ExportHidInputRecords(const char* exportFileName, const std::vector<HidTaskRecord>& taskList);

private:
    std::map<int32_t, std::string>  m_XpadButtonMap;
    std::map<int32_t, std::string>  m_DebugPadButtonMap;
    std::map<int32_t, std::string>  m_VirtualPadButtonMap;

    bool m_IsUpdateXpadConnection[MaxControllerCount];
    bool m_IsUpdateXpadState[MaxControllerCount];
    HidShellBasicXpadState m_XpadState[MaxControllerCount];

    bool m_IsUpdateDebugPadConnection;
    bool m_IsUpdateDebugPadState;
    HidShellDebugPadState m_DebugPadState;

    bool m_IsUpdateTouchScreenState;
    HidShellTouchScreenState m_TouchState;

    bool m_IsUpdateHomeButtonState;
    bool m_HomeButtonState;

    bool m_IsUpdateCaptureButtonState;
    bool m_CaptureButtonState;

    bool m_IsUpdateVirtualPadConnection[MaxControllerCount];
    bool m_IsUpdateVirtualPadState[MaxControllerCount];
    HidShellAbstractedPadState m_VirtualPadState[MaxControllerCount];

    void ExportIndent(FILE* fp, int indentLevel);
    void ExportSleep(FILE* fp, int indentLevel, int sleepSpan);

    void ExportScriptHeader(FILE*fp);
    void ExportScriptBody(FILE*fp, int indentLevel, const std::vector<HidTaskRecord>& taskList);

    void ExportHidControl(FILE*fp, int indentLevel);

    // xpad
    void ExportXpadConnectionRecord(FILE* fp, int indentLevel, const char* id, bool isConnect);
    void UpdateXpadState(HidShellBasicXpadState &state, std::vector<HidTaskRecord>::const_iterator& task);
    void ExportXpadState(FILE* fp, int indentLevel, int id, const HidShellBasicXpadState &state);
    // debug pad
    void ExportDebugPadConnectionRecord(FILE* fp, int indentLevel, bool isConnect);
    void UpdateDebugPadState(HidShellDebugPadState &state, std::vector<HidTaskRecord>::const_iterator& task);
    void ExportDebugPadState(FILE* fp, int indentLevel, const HidShellDebugPadState& state);
    // touch screen
    void UpdateTouchState(HidShellTouchScreenState &state, std::vector<HidTaskRecord>::const_iterator& task);
    void ExportTouchState(FILE* fp, int indentLevel, const HidShellTouchScreenState& state);
    // home button
    void ExportHomeButtonRecord(FILE* fp, int indentLevel, bool value);
    // capture button
    void ExportCaptureButtonRecord(FILE* fp, int indentLevel, bool value);
    // virtual pad
    void ExportVirtualPadConnectionRecord(FILE* fp, int indentLevel, int id, bool isConnect, HidShellAbstractedPadState &state);
    void UpdateVirtualPadState(HidShellAbstractedPadState &state, std::vector<HidTaskRecord>::const_iterator& task);
    void ExportVirtualPadState(FILE* fp, int indentLevel, int id, const HidShellAbstractedPadState &state);
};

