﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once
#include "ControllerOptions.h"

class PadInputer
{
public:
    PadInputer();
    virtual ~PadInputer();

    virtual void BeginAutoPilot() = 0;
    virtual void EndAutoPilot() = 0;
    virtual void SetDefault() = 0;
    virtual void SetState(const Button buttonList[], int buttonCount,
        const Stick stickList[], const ControllerStickValueType stickXList[], const ControllerStickValueType stickYList[], int stickCount) = 0;
    virtual void Press(Button button) = 0;
    virtual void Release(Button button) = 0;

    virtual void SetStickPos(Stick stick, ControllerStickValueType x, ControllerStickValueType y) = 0;
    virtual void SetLStickPos(ControllerStickValueType x, ControllerStickValueType y) = 0;
    virtual void SetRStickPos(ControllerStickValueType x, ControllerStickValueType y) = 0;
};
