﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <exception>
#include <sstream>

#include "common.h"

class InvalidImageIdException : public std::exception
{
public:
    explicit InvalidImageIdException(ImageIdType id)
    {
        m_InvalidImageId = id;
    }

    std::string what()
    {
        std::ostringstream outputString;
        outputString << "Invalid imageId was specified. ImageId=" << m_InvalidImageId.id;
        return outputString.str();
    }

private:
    ImageIdType       m_InvalidImageId;
};
