﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <dshow.h>
#include <string>
#include <Windows.h>



interface ISampleGrabberCB : public IUnknown
{
    virtual HRESULT STDMETHODCALLTYPE SampleCB(
        double SampleTime,
        IMediaSample *pSample) = 0;

    virtual HRESULT STDMETHODCALLTYPE BufferCB(
        double SampleTime,
        BYTE *pBuffer,
        LONG BufferLen) = 0;
};

interface ISampleGrabber : public IUnknown
{
    virtual HRESULT STDMETHODCALLTYPE SetOneShot(
        BOOL OneShot) = 0;

    virtual HRESULT STDMETHODCALLTYPE SetMediaType(
        const AM_MEDIA_TYPE *pType) = 0;

    virtual HRESULT STDMETHODCALLTYPE GetConnectedMediaType(
        AM_MEDIA_TYPE *pType) = 0;

    virtual HRESULT STDMETHODCALLTYPE SetBufferSamples(
        BOOL BufferThem) = 0;

    virtual HRESULT STDMETHODCALLTYPE GetCurrentBuffer(
        LONG *pBufferSize,
        LONG *pBuffer) = 0;

    virtual HRESULT STDMETHODCALLTYPE GetCurrentSample(
        IMediaSample **ppSample) = 0;

    virtual HRESULT STDMETHODCALLTYPE SetCallback(
        ISampleGrabberCB *pCallback,
        LONG WhichMethodToCallback) = 0;
};


class CaptureGrabber
{
public:
    CaptureGrabber();
    ~CaptureGrabber();

    bool Open( int deviceId, int width, int height );
    void Release();
    bool Read(unsigned char* pOutImageBuffer, long bufferSize);
    bool IsOpened();
    std::string GetDeviceName();

private:
    // 入力・出力用フィルタ作成
    HRESULT CreateSourceFilter();
    HRESULT CreateTransformFilter();

    // フィルタグラフ作成
    HRESULT CreateFilterGraph();

    // フィルタグラフマネージャー作成
    HRESULT CreateMediaControl();

    // ストリーム・メディアの形式設定
    HRESULT SetupStreamConfig();
    HRESULT SetupMediaConfig();

    // レンダー開始
    HRESULT RenderStart();

    std::string             m_DeviceName;
    int                     m_DeviceId;
    int                     m_Width;
    int                     m_Height;

    bool                    m_IsOpened;

    unsigned char*          m_ImageBuffer;
    int                     m_ImageBufferSize;

    IGraphBuilder*          m_GraphBuilder;
    ICaptureGraphBuilder2*  m_CaptureGraphBuilder2;
    IMediaControl*          m_MediaControl;

    // 入出力フィルタ
    IBaseFilter*            m_DeviceFilter;
    IBaseFilter*            m_SampleGrabberFilter;

    ISampleGrabber*         m_SampleGrabber;
};
