﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "ShopMonitoringTool_UiScene.h"

Scene::Scene()
{
    m_State = State::Disabled;
    m_pNextScene = nullptr;
    m_pPrevScene = nullptr;
    m_DrawPosX = 0;
    m_DrawPosY = 0;
}

Scene::~Scene()
{

}

Scene::State Scene::GetState()
{
    return m_State;
}

void Scene::SetState(Scene::State state)
{
    m_State = state;
}

void Scene::SetNextScene(Scene* pScene)
{
    m_pNextScene = pScene;
}

void Scene::SetPrevScene(Scene* pScene)
{
    m_pPrevScene = pScene;
}

void Scene::EscapeScene()
{
    if (this->m_pPrevScene == nullptr)
    {
        return;
    }
    m_State = Scene::State::Disabled;
}

void Scene::SetDrawPos(int x, int y)
{
    m_DrawPosX = x;
    m_DrawPosY = y;
}
