﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstdlib>
#include <cstring>
#include <vector>

#include "ShopMonitoringTool_SysFramework.h"
#include "ShopMonitoringTool_UiScene.h"

class MenuItem
{
public:
    enum SelectiveState
    {
        Default,    // 未選択
        Selected,   // 選択中
        Decided,    // 決定済み
    };
public:
    MenuItem(void);
    NN_IMPLICIT MenuItem(std::string name);
    MenuItem(std::string name, std::string description);
    virtual ~MenuItem();
    std::string GetName();
    std::string GetDescription();
    void SetName(std::string name);
    void SetDescription(std::string description);
    virtual std::string GetValueName();
    virtual void* GetValue();
    void SetState(SelectiveState state);
    bool IsEditable();
    void SetEditable(bool isEditable);
    bool IsSelectable();
    void SetSelectable(bool isSelectable);
    void SetNextScene(Scene* pScene);
    SelectiveState GetState();
    virtual Scene* CallEnter();
    virtual void CallIncrement();
    virtual void CallDecrement();
    std::function<bool()> AtatchedGeneralFunction;
protected:
    std::string m_Name;
    std::string m_Description;
private:
    bool m_IsEditable;
    bool m_IsSelectable;
    SelectiveState m_State;
    Scene*      m_pNextScene;
};
