﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "ShopMonitoringTool_UiMenuItem.h"

bool DefaultGeneralFunction()
{
    return true;
}

MenuItem::MenuItem()
{
    m_State = SelectiveState::Default;
    m_Name = "No name";
    m_Description = "No description";
    m_pNextScene = nullptr;
    AtatchedGeneralFunction = DefaultGeneralFunction;
    m_IsEditable = true;
    m_IsSelectable = true;
}

MenuItem::MenuItem(std::string name) : MenuItem()
{
    m_Name = name;
    m_Description = name;
}

MenuItem::MenuItem(std::string name, std::string description) : MenuItem()
{
    m_Name = name;
    m_Description = description;
}

MenuItem::~MenuItem()
{
}

std::string MenuItem::GetName()
{
    return m_Name;
}

std::string MenuItem::GetDescription()
{
    return m_Description;
}

void MenuItem::SetName(std::string name)
{
    m_Name = name;
}
void MenuItem::SetDescription(std::string description)
{
    m_Description = description;
}

std::string MenuItem::GetValueName()
{
    return "";
}

void* MenuItem::GetValue()
{
    return nullptr;
}

void MenuItem::SetState(SelectiveState state)
{
    m_State = state;
}

MenuItem::SelectiveState MenuItem::GetState()
{
    return m_State;
}

bool MenuItem::IsEditable()
{
    return m_IsEditable;
}
void MenuItem::SetEditable(bool isEditable)
{
    m_IsEditable = isEditable;
}
bool MenuItem::IsSelectable()
{
    return m_IsSelectable;
}
void MenuItem::SetSelectable(bool isSelectable)
{
    m_IsSelectable = isSelectable;
}

Scene* MenuItem::CallEnter()
{
    return m_pNextScene;
}

void MenuItem::CallIncrement()
{

}

void MenuItem::CallDecrement()
{

}

void MenuItem::SetNextScene(Scene* pScene)
{
    m_pNextScene = pScene;
}
