﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "ShopMonitoringTool_SysFramework.h"

class EasyIndicator
{
private:
    const int MaxIndex = 4;
    int m_StateIndex;
    int m_FrameCount;
    int m_UpdateFrameSpan;
public:
    NN_IMPLICIT EasyIndicator(int updateFrameSpan = 10)
    {
        m_UpdateFrameSpan = updateFrameSpan;
        m_FrameCount = 0;
        m_StateIndex = 0;
    }

    void SetUpdateFrameSpan(int updateFrameSpan)
    {
        m_UpdateFrameSpan = updateFrameSpan;
    }

    void Draw(int x = 100, int y = 100, int size = 120, nn::util::Color4u8Type color = { { 255, 255, 255, 255 } })
    {

        const int unitSize = size / 3;
        const nn::util::Color4u8Type mHighColor = { { color.v[0], color.v[1], color.v[2], 255 } };
        const nn::util::Color4u8Type mMiddColor = { { color.v[0], color.v[1], color.v[2], 120 } };
        const nn::util::Color4u8Type mLowColor  = { { color.v[0], color.v[1], color.v[2],  30 } };

        int h1x, h1y, h2x, h2y = 0;
        int m1x, m1y, m2x, m2y = 0;
        int l1x, l1y, l2x, l2y = 0;

        switch (m_StateIndex)
        {
        case 0:
            //High
            h1x = x + unitSize * 0;
            h1y = y + unitSize * 0;
            h2x = x + unitSize * 2;
            h2y = y + unitSize * 2;
            //Midd
            m1x = x + unitSize * 0;
            m1y = y + unitSize * 1;
            m2x = x + unitSize * 2;
            m2y = y + unitSize * 1;
            //Low
            l1x = x + unitSize * 0;
            l1y = y + unitSize * 2;
            l2x = x + unitSize * 2;
            l2y = y + unitSize * 0;
            break;
        case 1:
            //High
            h1x = x + unitSize * 1;
            h1y = y + unitSize * 0;
            h2x = x + unitSize * 1;
            h2y = y + unitSize * 2;
            //Midd
            m1x = x + unitSize * 0;
            m1y = y + unitSize * 0;
            m2x = x + unitSize * 2;
            m2y = y + unitSize * 2;
            //Low
            l1x = x + unitSize * 0;
            l1y = y + unitSize * 1;
            l2x = x + unitSize * 2;
            l2y = y + unitSize * 1;
            break;
        case 2:
            //High
            h1x = x + unitSize * 2;
            h1y = y + unitSize * 0;
            h2x = x + unitSize * 0;
            h2y = y + unitSize * 2;
            //Midd
            m1x = x + unitSize * 1;
            m1y = y + unitSize * 0;
            m2x = x + unitSize * 1;
            m2y = y + unitSize * 2;
            //Low
            l1x = x + unitSize * 0;
            l1y = y + unitSize * 0;
            l2x = x + unitSize * 2;
            l2y = y + unitSize * 2;
            break;
        case 3:
            //High
            h1x = x + unitSize * 0;
            h1y = y + unitSize * 1;
            h2x = x + unitSize * 2;
            h2y = y + unitSize * 1;
            //Midd
            m1x = x + unitSize * 2;
            m1y = y + unitSize * 0;
            m2x = x + unitSize * 0;
            m2y = y + unitSize * 2;
            //Low
            l1x = x + unitSize * 1;
            l1y = y + unitSize * 0;
            l2x = x + unitSize * 1;
            l2y = y + unitSize * 2;
            break;
        default: NN_UNEXPECTED_DEFAULT;
        }

        //描画
        gDrawer.DrawRect(h1x, h1y, unitSize, unitSize, mHighColor);
        gDrawer.DrawRect(h2x, h2y, unitSize, unitSize, mHighColor);
        gDrawer.DrawRect(m1x, m1y, unitSize, unitSize, mMiddColor);
        gDrawer.DrawRect(m2x, m2y, unitSize, unitSize, mMiddColor);
        gDrawer.DrawRect(l1x, l1y, unitSize, unitSize, mLowColor);
        gDrawer.DrawRect(l2x, l2y, unitSize, unitSize, mLowColor);

        //カウンタ更新
        m_FrameCount++;
        if (m_FrameCount >= m_UpdateFrameSpan) {
            m_FrameCount = 0;
            ++m_StateIndex %= MaxIndex;
        }
    }
};
