﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <map>

#include <nn/nifm.h>
#include <nn/ssl.h>
#include <nn/socket.h>
#include <nn/nsd/nsd_ApiForMenu.h>
#include <nn/nsd/nsd_Types.h>

#include "ShopMonitoringTool_SysFramework.h"
#include "ShopMonitoringTool_UiScene.h"
#include "ShopMonitoringTool_UiMenuItem.h"
#include "ShopMonitoringTool_UiValueItem.h"
#include "ShopMonitoringTool_UiLogViewScene.h"
#include "ShopMonitoringTool_AppTopMenu.h"
#include "ShopMonitoringTool_AppConfigMenu.h"
#include "ShopMonitoringTool_AppExecutor.h"
#include "ShopMonitoringTool_ShopCommandManager.h"

class SceneManager
{
public:
    struct ConfigStructure
    {
        int errorCountLimit;
        int autoRestartWaitTime;
        int autoRetryWaitTime;
        int asyncTimeout;
        int userIndex;
        bool isEnableAutoRestart;
        bool isEnableErrorApplet;
        char demoApplicationId[128];
        char ticketApplicationId[128];
        char ticketKeyId[128];
        char purchaseNsUid[128];
    };
    ConfigStructure m_ConfigData;
    ConfigStructure DefaultConfigData;
public:
    SceneManager();
    ~SceneManager();
    void Initialize();
    void Finalize();
    void MainLoop();
private:
    void UpdateConfigDependance();
    void ConstructAppScene();
    void SetupShopCommandManager();
    void DrawStatusBar();
    bool SetupCommandScene();
    bool SetupMonitoringScene();
    bool SaveConfigData();
private:
    ShopCommandManager* m_pShopCommandManager;
    TopMenu* m_pTopmenu;
    ConfigMenu* m_pConfigMenu;
    CommandExecutor* m_pExecutor;
    LogScene* m_pLogView;
    std::map<const char*, MenuItem*> m_ItemList;
    std::map<const char*, ExecuteItem*> m_CommandList;
    nn::nsd::EnvironmentIdentifier m_EnvironmentIdentifier;
    nn::socket::ConfigDefaultWithMemory m_SocketConfigWithMemory;
    std::string m_CurrentSceneDescription;
    bool m_IsEnableLogView;
};
