﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "ShopMonitoringTool_AppConfigMenu.h"
#include "ShopMonitoringTool_AppColorPalette.h"

ConfigMenu::ConfigMenu(std::string title)
    :MenuScene(title)
{
    m_interpolatedOffsetY = 0.f;
}

void ConfigMenu::Draw()
{
    const int hOffset = 40;
    const int hStrOffset = (hOffset - 20) / 2;
    const int wOffset = 24;
    const int mWindowWidth = 500;

    int startX = m_DrawPosX + wOffset;
    int itemStartPosY = m_DrawPosY;

    for (int i = 0; i < m_ItemList.size(); i++)
    {
        nn::util::Color4u8Type itemNameColor = AppColor::DefaultTextColor;
        nn::util::Color4u8Type itemValueColor = AppColor::ValueColor;
        MenuItem* pItem = GetItemList().at(i);
        if (pItem->IsSelectable()) {
            gWriter.SetCursor(startX, itemStartPosY + i*hOffset + hStrOffset);
            switch (pItem->GetState())
            {
            case MenuItem::SelectiveState::Selected:
            case MenuItem::SelectiveState::Decided:

                itemNameColor = AppColor::SelectedColor;

                {
                    int originalOffsetY = i*hOffset + 1;
                    m_interpolatedOffsetY = m_interpolatedOffsetY * 0.4f + originalOffsetY * 0.6f;
                    gDrawer.DrawRect(m_DrawPosX, itemStartPosY + (int)m_interpolatedOffsetY, 5, hOffset, itemNameColor);
                }
                break;
            case MenuItem::SelectiveState::Default:
            default:
                itemNameColor = AppColor::DefaultTextColor;
                break;
            }

            if (!pItem->IsEditable())
            {
                itemNameColor.v[3] = 50;
                itemValueColor.v[3] = 50;
            }


            gWriter.SetTextColor(itemNameColor);
            gWriter.Print(pItem->GetName().c_str());

            int stringWidth = gWriter.CalculateStringWidth(pItem->GetValueName().c_str());
            gWriter.SetCursor(m_DrawPosX + mWindowWidth - stringWidth, itemStartPosY + i*hOffset + hStrOffset);
            gWriter.SetTextColor(itemValueColor);
            gWriter.Print(pItem->GetValueName().c_str());
        }
        else
        {
            gWriter.SetCursor(m_DrawPosX, itemStartPosY + i*hOffset + hStrOffset);
            gWriter.SetTextColor(AppColor::HeaderItemColor);
            gWriter.Print((pItem->GetName()).c_str());
        }

    }

    // NextMenu
    if (GetState() == Scene::State::EnabledInactive)
    {
        m_pNextScene->Draw();
    }
}
