﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <memory>
#include <nn/nn_Abort.h>
#include "QCIT_CreateQrCode.h"

namespace qcit
{

void CreateQrCode( mw::qre::ImageInfo* pOutRawImageInfo, uint32_t* pOutRawImageSize, uint8_t* pHash, uint32_t hashSize ) NN_NOEXCEPT
{
    mw::qre::QREncoder encoder;
    const uint32_t qrCellSize = 4;
    const uint32_t bufferSize = mw::qre::QREncoder::GetEncodeBufferSize( hashSize, qrCellSize, 1 );
    std::unique_ptr< char[] > buffer( new char[ bufferSize ] );
    encoder.InitMemory( buffer.get() , bufferSize );

    mw::qre::EncodeData info = { hashSize, pHash, 5, 0, qrCellSize, mw::qre::ECC_LEVEL_M }; // { size, data, version, total, cell_size, ecc_level }
    NN_ABORT_UNLESS( encoder.Encode( &info ) );
    NN_ASSERT( encoder.GetDivCount() == 1 );

    const auto imageSize = *pOutRawImageSize = encoder.GetQRSize( 0, false );
    NN_ASSERT( imageSize > 0 );

    pOutRawImageInfo->rgbData = new uint8_t[ imageSize ];
    NN_ABORT_UNLESS( encoder.GetQRData( pOutRawImageInfo, 0 ) );
}

} // ~namespace qcit
