﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "Fan.h"
#include <nn/nn_Log.h>
#include <nn/os.h>
#include "../ClientCommon/CpuFan.h"

bool IsFanValid()
{
    ptd::lib::CpuFan fan;

    fan.SetMaxSpeed();
    nn::os::SleepThread(nn::TimeSpan::FromSeconds(15));

    auto rpm = fan.GetRpm();
    NN_LOG("rpm = %d\n", rpm);

    return rpm != 0;
}
