﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/os/os_Argument.h>
#include <nn/util/util_StringUtil.h>

namespace PreinstallAppWriter {

    bool HasOption(const char* option)
    {
        // argv[0] (プログラム名) は飛ばす
        for (int i = 1; i < nn::os::GetHostArgc(); i++)
        {
            auto* arg = nn::os::GetHostArgv()[i];
            if (nn::util::Strncmp(arg, option, strlen(option)) == 0)
            {
                return true;
            }
        }
        return false;
    }

    char* GetOptionArgument(const char* option)
    {
        // argv[0] (プログラム名) は飛ばす
        for (int i = 1; i < nn::os::GetHostArgc(); i++)
        {
            auto* arg = nn::os::GetHostArgv()[i];
            if (nn::util::Strncmp(arg, option, strlen(option)) == 0 && i + 1 < nn::os::GetHostArgc())
            {
                return nn::os::GetHostArgv()[i + 1];
            }
        }
        return nullptr;
    }

}

