﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/mii/mii_Nfp.h>
#include <nn/ncm/ncm_ContentMetaId.h>
#include <nn/hid/hid_Npad.h>
#include <nn/nfp/nfp_DebugTypes.h>

#include "graphics/NfpDebugTool_Renderer.h"

namespace nfpdebug {

extern const float DisplayLineOffset;
extern const float DisplayColumnOffset;

/**
 * @brief   Npad ID の名前を取得
 */
const char* GetNpadIdName(const nn::hid::NpadIdType& npadId) NN_NOEXCEPT;

/**
 * @brief   Npad の操作形態の名前を取得
 */
const char* GetNpadStyleName(const nn::hid::NpadIdType& npadId) NN_NOEXCEPT;

/**
 * @brief   NFC タグプロトコル名を取得
 */
const char* GetTagProtocolName(nn::nfp::NfcProtocol protocol) NN_NOEXCEPT;

/**
 * @brief   NFC タグタイプ名を取得
 */
const char* GetTagTypeName(nn::nfp::TagType tagType) NN_NOEXCEPT;

/**
 * @brief   FontRegion の名前を取得
 */
const char* GetFontRegionName(nn::nfp::FontRegion fontRegion) NN_NOEXCEPT;

/**
 * @brief   アプリケーションのヘッダを描画
 */
void PrintHeader(graphics::Renderer* pRenderer, const char* title) NN_NOEXCEPT;

/**
 * @brief   同一タグであるか判定
 */
bool IsSameTag(const nn::nfp::TagId& tagId1, const nn::nfp::TagId& tagId2) NN_NOEXCEPT;

/**
 * @brief   amiibo 内の ID から、実際の Application ID を取得
 */
nn::Bit64 GetActualApplicationId(
    const nn::ncm::ApplicationId& applicationId,
    nn::Bit8 applicationIdExt) NN_NOEXCEPT;

/**
 * @brief   Application ID を amiibo の内部表現に変換
 */
void GetApplicationIdForAmiibo(
    nn::ncm::ApplicationId* pOutApplicationId,
    nn::Bit8* pOutApplicationIdExt,
    nn::Bit64 actualApplicationId) NN_NOEXCEPT;

/**
 * @brief   NfpData から Extention CRC を計算
 */
nn::Bit32 GetExtentionCrc(const nn::nfp::NfpData& nfpData) NN_NOEXCEPT;

/**
 * @brief   Mii の StoreData を NFP 用の StoreData に変換
 */
nn::Result ConvertStoreDataToNfpMiiData(
    nn::mii::NfpStoreDataCore* pOutCore,
    nn::mii::NfpStoreDataExtention* pOutExtention,
    const nn::mii::StoreData& storeData) NN_NOEXCEPT;

/**
 * @brief   Mii データのサンプルを生成
 */
void CreateSampleMiiData(nn::mii::StoreData* pOutMiiData, int type) NN_NOEXCEPT;

/**
 * @brief   Result の文字列表現を取得
 */
const char* GetResultText(nn::Result result) NN_NOEXCEPT;

}  // nfpdebug
