﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <nn/mem.h>
#include "NandVerifier_HashList.h"
#include "NandVerifier_LabelButton.h"
#include "NandVerifier_PartitionDefinitions.h"

namespace
{
    const int MaxResultNum = MaxHashNum * 2;
}

struct HashInfo
{
    std::string hashValue;
    std::string fileName;

    bool operator<(const HashInfo& hashInfo) const
    {
        return hashValue < hashInfo.hashValue;
    }
};

class Viewer : public glv::ScissorBoxView
{
private:
    HashList** m_ppHashList;
    ToggleButton* m_SkipCompared[PartitionNum];

public:
    explicit Viewer(HashList** ppInHashList) NN_NOEXCEPT;

    void Initialize(std::function<void(std::string)> func);
    void Refresh() NN_NOEXCEPT;
    void ShowVerifyResult() NN_NOEXCEPT;
    void Settings() NN_NOEXCEPT;
    void AddVerifyResult(int i, std::string prefix, std::string hashValue, std::string fileName) NN_NOEXCEPT;
    bool Verify() NN_NOEXCEPT;

    void ClearAnswerFileList() NN_NOEXCEPT;
    nn::Result ReadAnswerFile(const char* path) NN_NOEXCEPT;
    nn::Result DumpVerifyResult(glv::Label* label) NN_NOEXCEPT;
    nn::Result EnumerateAnswerFiles(std::string rootPath) NN_NOEXCEPT;
    nn::Result ReadAnswerFileName(std::string fileName) NN_NOEXCEPT;
    nn::Result ReadFileList(std::string rootPath) NN_NOEXCEPT;

private:
    glv::Scroll* m_Scroll;
    glv::Table* m_pTable;

    VerifyButton* m_Labels[MaxResultNum];
    std::string m_Result[MaxResultNum];
    std::vector<HashInfo> m_Answer[PartitionNum];

    int m_ResultNum;
};
