﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief       振動が付与されたボタン作成ための API の宣言
 */

#pragma once

#include "hidfw/layout.h"

#include "VibrationDemo_AudioManager.h"
#include "VibrationDemo_Color.h"
#include "VibrationDemo_VibrationManager.h"
#include "VibrationDemo_ControllerManager.h"

namespace VibrationDemo
{
    /**
     * @brief       画面上に表示されるボタンを描画、状態更新等を行う為のクラスです
     */
    class VibrationItem : public nns::hidfw::layout::BaseItem
    {
    public:
        struct FileData
        {
            std::string fileName;
            float       volume;
            FileData(const char* file, float vol) NN_NOEXCEPT : fileName(file), volume(vol) {}
        };

    public:
        VibrationItem() NN_NOEXCEPT
        {
            SetDefault();
            m_SourceCount = 0;
            m_MasterGain = 1.f;
            m_VibrationBalance = 0.f;
        }

        virtual ~VibrationItem() {}

        virtual void Update() {}
        virtual void PrintText() {}
        virtual void Draw() {}

        //----------------------------------------------------------------
        //! @brief  振動
        //----------------------------------------------------------------
        void SetVibration(const nns::hidfw::layout::LayoutStateSet& state, const char* fileName) NN_NOEXCEPT;
        void SetVibration(const nns::hidfw::layout::LayoutStateSet& state, const char* fileName, float volume) NN_NOEXCEPT;

        void SetSoundEffect(const nns::hidfw::layout::LayoutStateSet& state, const char* fileName) NN_NOEXCEPT;
        void SetSoundEffect(const nns::hidfw::layout::LayoutStateSet& state, const char* fileName, float volume) NN_NOEXCEPT;

        void SetVibrationSources(VibrationSource<nn::hid::VibrationPlayer>** pSources, int count) NN_NOEXCEPT;

        float GetGain() NN_NOEXCEPT;
        void SetGain(float gain) NN_NOEXCEPT;

        const std::map<int, FileData>& GetVibrationFile() NN_NOEXCEPT;
        const std::map<int, FileData>& GetSoundEffectFile() NN_NOEXCEPT;

    protected:
        void SetVibrationBalance(const float value) NN_NOEXCEPT;
        float GetVibrationBalance() const NN_NOEXCEPT;
        void SetBnvibFile(const char* fileName) NN_NOEXCEPT;
        void SetBnvibFile(const char* fileName, float volume) NN_NOEXCEPT;
        void PlayVibration(nn::hid::NpadIdType id) NN_NOEXCEPT;
        void PlayVibration(nn::hid::NpadIdType id, nn::hid::NpadJoyDeviceType deviceType) NN_NOEXCEPT;

    protected:
        std::map<int, FileData> m_BnvibFileName;
        std::map<int, FileData> m_SoundFileName;

        VibrationSource<nn::hid::VibrationPlayer>* m_pVibrationSources[18];
        int m_SourceCount;

        float m_MasterGain;
        float m_VibrationBalance;
    };

}
