@echo off

setlocal
set PATH=%WINDIR%;%WINDIR%\System32;%~dp0

pushd %~dp0
cd ..\..\..\..
set NINTENDO_SDK_ROOT=%cd%
popd

set RUN_ON_TARGET=%NINTENDO_SDK_ROOT%\Tools\CommandLineTools\RunOnTarget.exe
set VIBRATION_COLLECTION=%NINTENDO_SDK_ROOT%\TargetTools\NX-NXFP2-a64\VibrationCollection\Release\VibrationCollection.nsp

echo ---------------------------------------------------------------------------
echo %0
echo ---------------------------------------------------------------------------

echo Please input a mode number and press Enter key.
echo   [0] Host - Use default root path (%NINTENDO_SDK_ROOT%\TargetTools\NX-NXFP2-a64\VibrationCollection\Release\Resources\)
echo   [1] Sd   - Use default root path (Nintendo\Resources\)
echo   [2] Host - Input root path
echo   [3] Sd   - Input root path

set /p input=">"
if defined input set INPUT=%input:"=%
if /i "%INPUT%" == "0" goto HostDefault
if /i "%INPUT%" == "1" goto SdDefault
if /i "%INPUT%" == "2" goto HostCustom
if /i "%INPUT%" == "3" goto SdCustom

echo Error: Invalid mode is specified.
goto Finish

:HostDefault
set STARTUP_ARG=%NINTENDO_SDK_ROOT%\TargetTools\NX-NXFP2-a64\VibrationCollection\Release\Resources\
set MOUNT_TYPE=host
goto Run

:SdDefault
set STARTUP_ARG=Nintendo\Resources\
set MOUNT_TYPE=sd
goto Run

:HostCustom
echo Please input a root path and press Enter key.
set /p input=">"
set STARTUP_ARG=%input%
set MOUNT_TYPE=host
goto Run

:SdCustom
echo Please input a root path and press Enter key.
set /p input=">"
set STARTUP_ARG=%input%
set MOUNT_TYPE=sd
goto Run

:Run

echo Running VibrationCollection...
%RUN_ON_TARGET% %VIBRATION_COLLECTION% --no-wait -- -%MOUNT_TYPE% %STARTUP_ARG%

:Finish
pause
endlocal
exit
