﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>

#include "../sgx/gui/SimpleGfx_Gui.h"
#include "../ui/UniquePadButton.h"
#include "../util/FirmwareImage.h"
#include "../util/UniquePadManager.h"

namespace nns { namespace hid { namespace ui {

/**
 * @brief   UniquePad の一覧を表示するクラスです。
 */
class UniquePadView final :
    public nns::sgx::gui::FlowLayoutContainer
{
    NN_DISALLOW_COPY(UniquePadView);
    NN_DISALLOW_MOVE(UniquePadView);

public:
    /**
     * @brief   ボタン決定時のコールバック関数型です。
     */
    typedef void(*DecideCallbackFunc)(const nn::hid::system::UniquePadId& id, uintptr_t arg);

public:
    UniquePadView() NN_NOEXCEPT;

    virtual ~UniquePadView() NN_NOEXCEPT NN_OVERRIDE;

    /**
     * @brief   UniquePad リストが空かどうか判定します。
     */
    bool IsEmpty() const NN_NOEXCEPT;

    /**
     * @brief   ボタン決定時のコールバックを設定します。
     */
    void SetDecideCallback(DecideCallbackFunc callback, uintptr_t arg) NN_NOEXCEPT;

    /**
     * @brief   更新対象の FW イメージを設定します。
     */
    void SetTargetImage(const util::FirmwareImage& image) NN_NOEXCEPT;

    void Initialize() NN_NOEXCEPT;

    void Finalize() NN_NOEXCEPT;

    virtual void Update() NN_NOEXCEPT NN_OVERRIDE;

    virtual void Render() NN_NOEXCEPT NN_OVERRIDE;

private:
    static void PushButtonHandler(NNS_SGX_GUI_EVENT_HANDLER_ARGS(pSender, arg)) NN_NOEXCEPT;

    void Refresh() NN_NOEXCEPT;

private:
    bool                        m_IsInitialized;
    util::UniquePadManager      m_Manager;
    nn::os::LightEventType      m_ManagerUpdateEvent;
    nns::sgx::gui::ButtonSkin   m_ButtonSkin;
    ui::UniquePadButton         m_Buttons[nn::hid::system::UniquePadIdCountMax];
    DecideCallbackFunc          m_DecideCallback;
    uintptr_t                   m_DecideCallbackArg;
};

}}}  // nns::hid::ui
