﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>

#include "../SimpleGfx_Types.h"
#include "SimpleGfx_GuiButtonBase.h"

namespace nns { namespace sgx { namespace gui {

/**
 * @brief   認識できる 9-patch のスケール点の最大数です。
 */
const int ScalePointMax = 1;

/**
 * @brief   9-patch のコンテンツ領域定義です。
 */
struct ContentsArea9Patch
{
    int offset;     //!< 開始位置
    int length;     //!< 長さ
};

/**
 * @brief   9-patch イメージです。
 */
struct Image9Patch
{
    const ImageData* pImage;
    int scalePointX[ScalePointMax];
    int scalePointY[ScalePointMax];
    ContentsArea9Patch contentsAreaHorizontal;
    ContentsArea9Patch contentsAreaVertical;
};

/**
 * @brief   システム効果音の種類です。
 */
enum class SystemSe
{
    Cursor,
    Press,
    Decide,
    Cancel,
    Buzzer,
    Notice,
    Success,
    Failure
};

/**
 * @brief   矩形を可視領域に変換します。
 */
void ClampVisibility(Rectangle* pRect) NN_NOEXCEPT;

/**
 * @brief   画像を 9-patch イメージとして解析します。
 */
void Parse9PatchImage(Image9Patch* pOutImage, const ImageData& srcImage) NN_NOEXCEPT;

/**
 * @brief   9-patch 画像を描画します。
 */
void Draw9PatchImage(const Image9Patch& image) NN_NOEXCEPT;

/**
 * @brief   画像ボタンを描画します。
 */
void DrawImageButton(
    const ImageData& image,
    float x,
    float y,
    float width,
    float height,
    ButtonAppearance appearance) NN_NOEXCEPT;

/**
 * @brief   システム効果音を再生します。
 */
void PlaySystemSe(SystemSe se) NN_NOEXCEPT;

}}}  // nns::sgx::gui
