﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <vector>

#include <nn/nn_Assert.h>
#include <nn/nn_Log.h>
#include <nn/os.h>

#include "../SimpleGfx_Types.h"
#include "SimpleGfx_GuiCommon.h"

namespace nns { namespace sgx { namespace gui {

/**
 * @brief   タイトルの Z オーダー初期値です。
 */
const int TitleDefaultZ = 10000;

/**
 * @brief   タイトルに表示できるテキストの最大長です。終端文字は含みません。
 */
const int TitleTextLengthMax = 64;

/**
 * @brief   タイトル表示を扱うクラスです。
 */
class Title :
    public DisplayObject
{
    NN_DISALLOW_COPY(Title);
    NN_DISALLOW_MOVE(Title);

public:
    Title() NN_NOEXCEPT;

    explicit Title(const char* text) NN_NOEXCEPT;

    /**
     * @brief   タイトルに表示するアイコン画像を設定します。
     */
    void SetIconImage(ImageData* pImage) NN_NOEXCEPT;

    /**
     * @brief   タイトルに表示するテキストを設定します。
     */
    void SetText(const char* text) NN_NOEXCEPT;

    virtual void Update() NN_NOEXCEPT NN_OVERRIDE;

    virtual void Render() NN_NOEXCEPT NN_OVERRIDE;

private:
    ImageData*  m_pIconImage;
    Color       m_TextColor;
    char        m_Text[TitleTextLengthMax + 1];
};

}}}  // nns::sgx::gui
