﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Assert.h>
#include <nn/nn_Log.h>
#include <nn/os.h>

#include "../SimpleGfx_Types.h"
#include "SimpleGfx_GuiCommon.h"

namespace nns { namespace sgx { namespace gui {

/**
 * @brief   スプライトを扱うクラスです。
 */
class Sprite :
    public DisplayObject
{
    NN_DISALLOW_COPY(Sprite);
    NN_DISALLOW_MOVE(Sprite);

public:
    Sprite() NN_NOEXCEPT
        : m_pImage(nullptr)
        , m_SrcRect()
    {}

    /**
     * @brief   表示する画像を指定します。
     */
    void SetImage(ImageData* pImage) NN_NOEXCEPT
    {
        NN_ASSERT_NOT_NULL(pImage);
        NNS_SGX_GUI_SCOPED_LOCK;

        m_pImage = pImage;
    }

    /**
     * @brief   表示する画像の範囲を取得します。
     */
    void GetSrcRectangle(Rectangle* pOutValue) const NN_NOEXCEPT
    {
        NN_ASSERT_NOT_NULL(pOutValue);
        NNS_SGX_GUI_SCOPED_LOCK;

        *pOutValue = m_SrcRect;
    }

    /**
     * @brief   表示する画像の範囲を指定します。
     */
    void SetSrcRectangle(const Rectangle& srcRect) NN_NOEXCEPT
    {
        NNS_SGX_GUI_SCOPED_LOCK;

        m_SrcRect = srcRect;
    }

    virtual void Update() NN_NOEXCEPT NN_OVERRIDE;

    virtual void Render() NN_NOEXCEPT NN_OVERRIDE;

private:
    ImageData*  m_pImage;       //!< 表示する画像データ
    Rectangle   m_SrcRect;      //!< 表示する画像の範囲
};

}}}  // nns::sgx::gui
