﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "NpadManager.h"
#include "TouchPanel.h"

namespace input {

/**
 * @brief   入力系を初期化するヘルパー関数です。
 */
NN_FORCEINLINE
void Initialize() NN_NOEXCEPT
{
    nn::hid::InitializeNpad();
    nn::hid::InitializeTouchScreen();
}

/**
 * @brief   入力系を更新するヘルパー関数です。
 */
NN_FORCEINLINE
void Update() NN_NOEXCEPT
{
    NpadManager::GetInstance()->Update();
    TouchPanel::GetInstance()->Update();
}

}  // input
