﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief       画面上に表示されるボタン作成ための API の宣言
 */

#pragma once

#include "layout_Base.h"

namespace nns { namespace hidfw { namespace layout {

    /**
     * @brief       画面上に表示されるボタンを描画、状態更新等を行う為のクラスです
     */
    class Button : public BaseItem
    {
    public:
        Button() NN_NOEXCEPT;
        virtual ~Button() NN_NOEXCEPT {}

        virtual void Update() NN_NOEXCEPT;
        virtual void PrintText() NN_NOEXCEPT;
        virtual void Draw() NN_NOEXCEPT;
    };

}}}
