﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "layout_Button.h"

namespace nns { namespace hidfw { namespace layout {

    Button::Button() NN_NOEXCEPT
    {
        SetDefault();
    }

    void Button::Update() NN_NOEXCEPT
    {
        ++m_FrameCount;

        if (m_AnimationCount > 0)
        {
            --m_AnimationCount;
        }
        else
        {
            m_State.Reset<LayoutState::Animation>();
        }

        if ((m_OldState.Test<LayoutState::Selected>() != m_State.Test<LayoutState::Selected>()))
        {
            if (m_Option.Test<LayoutOption::OnOffMode>())
            {
                if (m_State.Test<LayoutState::Selected>() && m_Option.Test<LayoutOption::CallFunction>())
                {
                    CallFunc();
                }
            }
            else if (m_State.Test<LayoutState::Selected>() && m_Option.Test < LayoutOption::ImmediateExecute>() && m_Option.Test<LayoutOption::CallFunction>())
            {
                CallFunc();
            }
            m_AnimationCount = 7;
            m_State.Set<LayoutState::Animation>();
        }
        else if (!m_Option.Test<LayoutOption::OnOffMode>() && m_State.Test<LayoutState::Selected>())
        {
            if (!m_State.Test<LayoutState::Animation>())
            {
                if (m_Option.Test<LayoutOption::CallFunction>() && !m_Option.Test<LayoutOption::ImmediateExecute>())
                {
                    CallFunc();
                }
                Cancel();
                m_AnimationCount = 7;
            }
        }

        if (m_AnimationCount > 0)
        {
            if (m_State.Test<LayoutState::Selected>())
            {
                m_Scale = nn::util::MakeFloat2(1.0f - (static_cast<float>(m_AnimationCount) / 70.f), 1.0f - (static_cast<float>(m_AnimationCount) / 70.f));
            }
            else
            {
                m_Scale = nn::util::MakeFloat2(0.95f + (static_cast<float>(m_AnimationCount) / 70.f), 0.95f + (static_cast<float>(m_AnimationCount) / 70.f));
            }
        }
        else
        {
            if (m_State.Test<LayoutState::Selected>())
            {
                m_Scale = nn::util::MakeFloat2(0.98f, 0.98f);
            }
            else
            {
                m_Scale = nn::util::MakeFloat2(1.f, 1.f);
            }
        }
    }

    void Button::PrintText() NN_NOEXCEPT
    {
        gTextWriter.SetScale(m_Scale.x, m_Scale.y);

        const nn::util::Float2 textPos = nn::util::MakeFloat2(
            m_Pos.x + (m_Size.x - gTextWriter.CalculateStringWidth(m_Text.c_str())) / 2.f,
            m_Pos.y + (m_Size.y - gTextWriter.CalculateStringHeight(m_Text.c_str())) / 2.f);

        if (m_State.Test<LayoutState::Selected>())
        {
            gTextWriter.SetTextColor(nn::util::Color4u8::Gray());
        }
        else
        {
            gTextWriter.SetTextColor(m_TextColor);
        }
        gTextWriter.SetCursor(textPos.x, textPos.y);
        gTextWriter.Print(m_Text.c_str());

        m_OldState = m_State;
        m_State.Set(LayoutState::Canceled::Index, false);
    }

    void Button::Draw() NN_NOEXCEPT
    {
        //!< 拡大率を考慮したボタンのサイズ
        const nn::util::Float2 buttonSize = nn::util::MakeFloat2(
            m_Size.x * m_Scale.x,
            m_Size.y * m_Scale.y);
        //!< 拡大率を考慮したボタンの位置
        const nn::util::Float2 buttonPos = nn::util::MakeFloat2(
            m_Pos.x - (buttonSize.x - m_Size.x) / 2.f,
            m_Pos.y - (buttonSize.y - m_Size.y) / 2.f);

        //!< ボタンに照準があっている場合の色
        const nn::util::Color4u8 hoverColor = nn::util::Color4u8::Lerp(nn::util::Color4u8(255, 255, 170, 255), nn::util::Color4u8(255, 255, 114, 255), (nn::util::SinEst(nn::util::DegreeToRadian((m_FrameCount % 120) * 3)) + 1.f) / 2.f);
        //!< ボタンの影の色
        const nn::util::Color4u8 shadowColor = nn::util::Color4u8(30, 66, 128, 255);

        //!< 補正済みのボタンの色
        const nn::util::Color4u8 mainColor = m_State.Test<LayoutState::Hover>() ? nn::util::Color4u8::Lerp(m_MainColor, hoverColor, 0.8f) : m_MainColor;
        //!< ボタン最下部の色
        const nn::util::Color4u8 subColor = nn::util::Color4u8::Lerp(mainColor, shadowColor, 0.55f);

        //!< ボタン選択時のエフェクトの色
        const nn::util::Color4u8 effectColor = m_EffectColor;
        const nn::util::Color4u8 effectColorZero = nn::util::Color4u8(effectColor.v[0], effectColor.v[1], effectColor.v[2], 0);

        const nn::util::Color4u8 black = nn::util::Color4u8(60, 70, 80, 255);
        const nn::util::Color4u8 blackZero = nn::util::Color4u8(60, 70, 80, 0);

        if (m_State.Test<LayoutState::Selected>())
        {
            if (m_State.Test<LayoutState::Hover>())
            {
                float effect = nn::util::SinEst(nn::util::DegreeToRadian((m_FrameCount % 120) * 3)) * 1.f + 5.f;
                gDrawer.SetColor(nns::hidfw::gfx::GraphicsDrawer::GradationDirection_Down, effectColor, effectColorZero);
                gDrawer.Draw2DRoundedFrame(buttonPos, buttonSize, 0.4f, 24, effect);
            }

            gDrawer.SetColor(nns::hidfw::gfx::GraphicsDrawer::GradationDirection_Down, m_State.Test<LayoutState::Hover>() ? effectColor : black, m_State.Test<LayoutState::Hover>() ? effectColorZero : blackZero);
            gDrawer.Draw2DRoundedFrame(buttonPos, buttonSize, 0.4f, 24, 1.5f);
            gDrawer.SetColor(nns::hidfw::gfx::GraphicsDrawer::GradationDirection_Up, black, nn::util::Color4u8::Black());
            gDrawer.Draw2DRoundedRect(buttonPos, buttonSize, 0.4f, 24);
            gDrawer.SetColor(nns::hidfw::gfx::GraphicsDrawer::GradationDirection_Down, m_State.Test<LayoutState::Hover>() ? effectColor : black, m_State.Test<LayoutState::Hover>() ? effectColorZero : blackZero);
            gDrawer.Draw2DRoundedFrame(buttonPos, buttonSize, 0.4f, 24, -1.f);


        }
        else
        {
            if (m_State.Test<LayoutState::Hover>())
            {
                float effect = nn::util::SinEst(nn::util::DegreeToRadian((m_FrameCount % 120) * 3)) * 1.f + 5.f;
                gDrawer.SetColor(nns::hidfw::gfx::GraphicsDrawer::GradationDirection_Down, effectColor, effectColorZero);
                gDrawer.Draw2DRoundedFrame(buttonPos, buttonSize, 0.4f, 24, effect);
            }
            gDrawer.SetColor(nns::hidfw::gfx::GraphicsDrawer::GradationDirection_Down, black, blackZero);
            gDrawer.Draw2DRoundedFrame(buttonPos, buttonSize, 0.4f, 24, 1.5f);
            gDrawer.SetColor(nns::hidfw::gfx::GraphicsDrawer::GradationDirection_Down, black, blackZero);
            gDrawer.Draw2DRoundedFrame(buttonPos, buttonSize, 0.4f, 24, 1.5f);
            gDrawer.SetColor(nns::hidfw::gfx::GraphicsDrawer::GradationDirection_Down, mainColor, subColor);
            gDrawer.Draw2DRoundedRect(buttonPos, buttonSize, 0.4f, 24);
            gDrawer.SetColor(nns::hidfw::gfx::GraphicsDrawer::GradationDirection_Down, black, blackZero);
            gDrawer.Draw2DRoundedFrame(buttonPos, buttonSize, 0.4f, 24, -1.f);

        }
    }
}}}
