﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once
#include <nn/rid.h>
#include "DevQuestMenu_ModeSceneCommon.h"

namespace nn { namespace devquestmenu {

    /**
     * @brief       本体更新モード
     *
     */
    class SystemUpdateModeScene : public ModeSceneCommon
    {
    public:

        /**
         * @brief       本体更新モード起動時処理を行います
         *
         * @detail      本体更新を実行するスレッドを生成・実行します。
         */
        explicit SystemUpdateModeScene(RootSurfaceContext* pRootSurface) NN_NOEXCEPT;

        /**
         * @brief       本体更新モード終了時処理を行います。
         *
         */
        ~SystemUpdateModeScene() NN_NOEXCEPT;

        /**
         * @brief       本体更新をポーリングします
         *
         */
        void OnLoop() NN_NOEXCEPT NN_OVERRIDE;

        /**
         * @brief       アプリケーション更新モードに遷移できるかを判定します
         *
         * @param[in]   displayModeTime     更新開始時間の設定
         *
         */
        ModeType DetermineNextMode(const DisplayModeTime& displayModeTime) NN_NOEXCEPT NN_OVERRIDE;

        ModeType GetSuccessNextMode() NN_NOEXCEPT NN_OVERRIDE;

    private:

        void InitializeView() NN_NOEXCEPT;

        nn::Result m_SystemUpdateResult;                                    //! 本体更新結果
        bool m_IsSystemUpdateDone = false;                                  //! 本体更新が終了したかどうかの判定
        nn::rid::SystemUpdater m_SystemUpdater;                             //! rid システムアップデータ
        nn::os::ThreadType m_UpdateExecutionThread;                         //! アップデート実行スレッド

        //! 描画オブジェクトの位置
        glv::Rect m_ProgressSliderRect = { m_GridWidth * 11.2f, m_GridHeight * 9, m_GridWidth * 4.6f, m_GridHeight * 2 };
        glv::Label::Spec m_StatusLabelSpec = { glv::Place::TL, m_GridWidth * 11.2f, m_GridHeight * 7, 25.f };

        //! 描画オブジェクト
        std::unique_ptr<glv::Label> m_SystemUpdateStatus;                   //! 更新状況のラベル
        std::unique_ptr<glv::Slider> m_SystemUpdateProgress;                //! 更新の Progress バー
    };
}}
