﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once
#include <nn/rid.h>
#include "DevQuestMenu_ModeSceneCommon.h"

namespace nn { namespace devquestmenu {

    /**
     * @brief       試遊台メニュー更新モード
     *
     */
    class MenuUpdateModeScene : public ModeSceneCommon
    {
    public:

        /**
         * @brief       試遊台メニュー更新モード起動時処理を行います
         *
         */
        explicit MenuUpdateModeScene(RootSurfaceContext* pRootSurface) NN_NOEXCEPT;

        /**
         * @brief       試遊台メニュー更新モード終了時処理を行います。
         *
         */
        ~MenuUpdateModeScene() NN_NOEXCEPT;

        /**
         * @brief       試遊台メニュー更新をポーリングします
         *
         */
        void OnLoop() NN_NOEXCEPT NN_OVERRIDE;

        /**
         * @brief       アプリケーション更新モードに遷移できるかを判定します
         *
         * @param[in]   displayModeTime     更新開始時間の設定
         *
         */
        ModeType DetermineNextMode(const DisplayModeTime& displayModeTime) NN_NOEXCEPT NN_OVERRIDE;

        ModeType GetSuccessNextMode() NN_NOEXCEPT NN_OVERRIDE;

    private:

        void InitializeView() NN_NOEXCEPT;

        bool m_IsMenuUpdateDone = false;                                  //! 試遊台メニュー更新が終了したかどうかの判定
        nn::rid::MenuUpdater m_MenuUpdater;                               //! rid メニューアップデータ
        nn::os::ThreadType m_UpdateExecutionThread;                       //! アップデート実行スレッド
        nn::Result m_MenuUpdateResult;                                    //! メニューの更新結果

        //! 描画オブジェクトの位置
        glv::Rect m_ProgressSliderRect = { m_GridWidth * 11.2f, m_GridHeight * 9, m_GridWidth * 4.6f, m_GridHeight * 2 };
        glv::Label::Spec m_StatusLabelSpec = { glv::Place::TL, m_GridWidth * 11.2f, m_GridHeight * 7, 25.f };

        //! 描画オブジェクト
        std::unique_ptr<glv::Label> m_MenuUpdateStatus;                   //! 更新状況のラベル
    };
}}
