﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include "../ui_IMenuItem.h"

namespace ui{ namespace util{

    class ProcessButtonHandling
    {
    public:
        static MenuButtonResult HandlePositiveButtonPressed(const std::shared_ptr<IMenuItem>& pItem, const MenuButtonHandleContext& context) NN_NOEXCEPT
        {
            if(!pItem)
            {
                return MenuButtonResult::GetNotHandled();
            }

            MenuButtonResult result =MenuButtonResult::GetNotHandled();
            if(pItem->IsEnabled())
            {
                result = pItem->HandlePositiveButtonPressed(context);
            }

            if(!result.IsHandled())
            {
                if(auto pParent = pItem->GetParentInfo().pParent.lock())
                {
                    auto innerContext = MenuButtonHandleContext::CreateNextContext(pItem, context);
                    return HandlePositiveButtonPressed(pParent, innerContext);
                }
            }
            return result;
        }

        static MenuButtonResult HandleNegativeButtonPressed(const std::shared_ptr<IMenuItem>& pItem, const MenuButtonHandleContext& context) NN_NOEXCEPT
        {
            if(!pItem)
            {
                return MenuButtonResult::GetNotHandled();
            }

            MenuButtonResult result =MenuButtonResult::GetNotHandled();
            if(pItem->IsEnabled())
            {
                result = pItem->HandleNegativeButtonPressed(context);
            }

            if(!result.IsHandled())
            {
                if(auto pParent = pItem->GetParentInfo().pParent.lock())
                {
                    auto innerContext = MenuButtonHandleContext::CreateNextContext(pItem, context);
                    return HandleNegativeButtonPressed(pParent, innerContext);
                }
            }
            return result;
        }

        static MenuButtonResult HandleUpButtonPressed(const std::shared_ptr<IMenuItem>& pItem, const MenuButtonHandleContext& context) NN_NOEXCEPT
        {
            if(!pItem)
            {
                return MenuButtonResult::GetNotHandled();
            }

            MenuButtonResult result =MenuButtonResult::GetNotHandled();
            if(pItem->IsEnabled())
            {
                result = pItem->HandleUpButtonPressed(context);
            }

            if(!result.IsHandled())
            {
                if(auto pParent = pItem->GetParentInfo().pParent.lock())
                {
                    auto innerContext = MenuButtonHandleContext::CreateNextContext(pItem, context);
                    return HandleUpButtonPressed(pParent, innerContext);
                }
            }
            return result;
        }

        static MenuButtonResult HandleDownButtonPressed(const std::shared_ptr<IMenuItem>& pItem, const MenuButtonHandleContext& context) NN_NOEXCEPT
        {
            if(!pItem)
            {
                return MenuButtonResult::GetNotHandled();
            }

            MenuButtonResult result =MenuButtonResult::GetNotHandled();
            if(pItem->IsEnabled())
            {
                result = pItem->HandleDownButtonPressed(context);
            }

            if(!result.IsHandled())
            {
                if(auto pParent = pItem->GetParentInfo().pParent.lock())
                {
                    auto innerContext = MenuButtonHandleContext::CreateNextContext(pItem, context);
                    return HandleDownButtonPressed(pParent, innerContext);
                }
            }
            return result;
        }

        static MenuButtonResult HandleRightButtonPressed(const std::shared_ptr<IMenuItem>& pItem, const MenuButtonHandleContext& context) NN_NOEXCEPT
        {
            if(!pItem)
            {
                return MenuButtonResult::GetNotHandled();
            }

            MenuButtonResult result =MenuButtonResult::GetNotHandled();
            if(pItem->IsEnabled())
            {
                result = pItem->HandleRightButtonPressed(context);
            }

            if(!result.IsHandled())
            {
                if(auto pParent = pItem->GetParentInfo().pParent.lock())
                {
                    auto innerContext = MenuButtonHandleContext::CreateNextContext(pItem, context);
                    return HandleRightButtonPressed(pParent, innerContext);
                }
            }
            return result;
        }

        static MenuButtonResult HandleLeftButtonPressed(const std::shared_ptr<IMenuItem>& pItem, const MenuButtonHandleContext& context) NN_NOEXCEPT
        {
            if(!pItem)
            {
                return MenuButtonResult::GetNotHandled();
            }

            MenuButtonResult result =MenuButtonResult::GetNotHandled();
            if(pItem->IsEnabled())
            {
                result = pItem->HandleLeftButtonPressed(context);
            }

            if(!result.IsHandled())
            {
                if(auto pParent = pItem->GetParentInfo().pParent.lock())
                {
                    auto innerContext = MenuButtonHandleContext::CreateNextContext(pItem, context);
                    return HandleLeftButtonPressed(pParent, innerContext);
                }
            }
            return result;
        }

    };

}}
