﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "ui_RadioButton.h"

#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>
#include "../Config.h"
#include "ui_RadioButtonGroup.h"

namespace ui{

    RadioButton::RadioButton(const std::shared_ptr<RadioButtonGroup>& pGroup) NN_NOEXCEPT
    {
        m_pGroup = pGroup;
    }

    RadioButton::~RadioButton() NN_NOEXCEPT
    {
    }

    std::shared_ptr<RadioButtonGroup> RadioButton::GetGroup() NN_NOEXCEPT
    {
        return m_pGroup;
    }

    std::shared_ptr<RadioButton> RadioButton::SetValueChangedCallbackFunction(const std::function<void (bool, const std::shared_ptr<IMenuPage>&)>& function) NN_NOEXCEPT
    {
        m_ValueChangedCallbackFunction = function;
        return this->shared_from_this();
    }

    bool RadioButton::IsSelected() const NN_NOEXCEPT
    {
        return m_pGroup
            && m_pGroup->GetSelectedItem() == this->shared_from_this();
    }

    void RadioButton::SetSelected(bool value, const std::shared_ptr<IMenuPage>& pPage) NN_NOEXCEPT
    {
        if(m_pGroup)
        {
            if(value)
            {
                m_pGroup->SetSelectedItem(this->shared_from_this(), pPage);
            }
            else if(m_pGroup->GetSelectedItem() == this->shared_from_this())
            {
                m_pGroup->SetSelectedItem(nullptr, pPage);
            }
        }
    }

    void RadioButton::NotifySelectedStateChanged(bool value, const std::shared_ptr<IMenuPage>& pPage) NN_NOEXCEPT
    {
        if(m_ValueChangedCallbackFunction)
        {
            m_ValueChangedCallbackFunction(value, pPage);
        }
    }

}

