﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "ui_MenuItemLabel.h"

#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>
#include "../framework/Framework.h"
#include "util/ui_CalculateItemSize.h"
#include "util/ui_CalculateTextSize.h"
#include "util/ui_CalculateAlignedPosition.h"

namespace ui{

    MenuItemLabel::MenuItemLabel(const MenuItemLabelStyle& style, const std::string& text) NN_NOEXCEPT
    {
        m_pPanel = std::make_shared<panel::PanelText>();
        m_pPanel->SetText(text);

        m_Style = style;
    }

    void MenuItemLabel::UpdateLayoutRecursively(const MenuLayoutUpdateContext& context) NN_NOEXCEPT
    {
        NN_UNUSED(context);
        const auto& text = m_pPanel->GetText();
        auto margin = m_Style.GetMargin();
        Size textSize = util::CalculateTextSize::Calculate(text.c_str(), m_Style.GetTextStyle(IsEnabled(), IsFocused()).GetFontSize(), framework::TextWriterUsage_Text);
        Size layoutSize = {
            textSize.width + margin.left + margin.right,
            textSize.height + margin.top + margin.bottom
        };

        auto outerSize = util::CalculateItemSize::Calculate([&](){ return layoutSize; }, m_Style.GetSizeStyle());

        auto layoutPosition = util::CalculateAlignedPosition::Calculate(layoutSize, outerSize, m_Style.GetAlignment());

        SetLayoutSize(outerSize);
        m_TextPosition = {layoutPosition.x + margin.left, layoutPosition.y + margin.top};
    }

    bool MenuItemLabel::IsFocusAcceptable() const NN_NOEXCEPT
    {
        return IsEnabled() && this->HasButtonCallbackFunction();
    }

    bool MenuItemLabel::IsTouchAcceptable() const NN_NOEXCEPT
    {
        return IsEnabled() && this->HasButtonCallbackFunction();
    }

    std::shared_ptr<panel::IPanel> MenuItemLabel::GetPanel() NN_NOEXCEPT
    {
        return m_pPanel;
    }

    void MenuItemLabel::UpdatePanel() NN_NOEXCEPT
    {
        auto textStyle = m_Style.GetTextStyle(IsEnabled(), IsFocused());
        auto pos = this->GetLayoutPosition();
        auto size =this->GetLayoutSize();

        m_pPanel->SetVisibility(panel::PanelVisibility::Visible);
        m_pPanel->SetColor(m_Style.GetBackgroundColor(IsEnabled(), IsFocused()));
        m_pPanel->SetPosition(pos.x, pos.y);
        m_pPanel->SetSize(size.width, size.height);
        m_pPanel->SetTextPosition(m_TextPosition.x, m_TextPosition.y);
        m_pPanel->SetTextColor(textStyle.GetFontColor());
        m_pPanel->SetTextSize(textStyle.GetFontSize());
    }

}

