﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include "base/ui_MenuItemBase.h"
#include "base/ui_MenuItemTableBase.h"

namespace ui{

    class MenuItemColumn
        : public  base::MenuItemTableBase
                < base::MenuItemBase<IMenuItem, MenuItemColumn>
                >
    {
    public:
        explicit MenuItemColumn(const MenuItemTableStyle& style) NN_NOEXCEPT;
        ~MenuItemColumn() NN_NOEXCEPT;

        virtual void UpdateLayoutRecursively(const MenuLayoutUpdateContext& context) NN_NOEXCEPT UI_FINAL;
        virtual MenuButtonResult HandleUpButtonPressed(const MenuButtonHandleContext& context) NN_NOEXCEPT UI_FINAL;
        virtual MenuButtonResult HandleDownButtonPressed(const MenuButtonHandleContext& context) NN_NOEXCEPT UI_FINAL;
    };

}
