﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include "base/ui_ItemState.h"

namespace ui{

    enum ItemStateFilter : uint64_t
    {
        ItemStateFilter_None = ~base::ItemStateFlag_All,
        ItemStateFilter_Any  = ~base::ItemStateFlag_None,

        ItemStateFilter_Disabled = base::ItemStateFlag_Disabled | ~base::ItemStateFlag_EnablityMask,
        ItemStateFilter_Enabled  = base::ItemStateFlag_Enabled  | ~base::ItemStateFlag_EnablityMask,

        ItemStateFilter_OutFocus  = base::ItemStateFlag_OutFocus | ~base::ItemStateFlag_FocusMask,
        ItemStateFilter_InFocus   = base::ItemStateFlag_InFocus  | ~base::ItemStateFlag_FocusMask,

        ItemStateFilter_NotSelected  = base::ItemStateFlag_NotSelected | ~base::ItemStateFlag_SelectionMask,
        ItemStateFilter_Selected     = base::ItemStateFlag_Selected    | ~base::ItemStateFlag_SelectionMask,
    };

    typedef uint64_t ItemStateFilterType;
}
