﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <functional>
#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include "../ui_IMenuItem.h"
#include "../ui_Macro.h"

namespace ui{ namespace base{

    // A ボタンやタッチ時にユーザーが設定したコールバックを呼び出す。
    // このアイテム自身がフォーカスを受け取れることが必要。
    template<typename TBaseType>
    class MenuItemAttributeButtonCallback
        : public TBaseType
    {
    public:
        typedef typename TBaseType::ConcreteType ConcreteType;

    public:
        virtual MenuButtonResult HandlePositiveButtonPressed(const MenuButtonHandleContext& context) NN_NOEXCEPT UI_FINAL
        {
            if(this->IsFocusAcceptable() && m_OnButtonCallbackFunction)
            {
                m_OnButtonCallbackFunction(context.GetPage());
                return MenuButtonResult::GetHandled();
            }
            return MenuButtonResult::GetNotHandled();
        }

        virtual MenuButtonResult HandleTouched(const MenuButtonHandleContext& context, const nn::util::Vector3f& position) NN_NOEXCEPT UI_FINAL
        {
            if(this->IsFocusAcceptable() && m_OnButtonCallbackFunction)
            {
                if(context.GetCurrentFocusedItem() == this->shared_from_this())
                {
                    m_OnButtonCallbackFunction(context.GetPage());
                }
                else
                {
                    context.GetPage()->ChangeFocus(this->shared_from_this());
                }
                return MenuButtonResult::GetHandled();
            }
            return MenuButtonResult::GetNotHandled();
        }

        std::shared_ptr<ConcreteType> SetButtonCallbackFunction(const std::function<void (const std::shared_ptr<IMenuPage>&)>& value) NN_NOEXCEPT
        {
            m_OnButtonCallbackFunction = value;
            return this->shared_from_this();
        }

    protected:
        bool HasButtonCallbackFunction() const NN_NOEXCEPT
        {
            return m_OnButtonCallbackFunction ? true : false;
        }

    private:
        std::function<void (const std::shared_ptr<IMenuPage>&)> m_OnButtonCallbackFunction;
    };

}}

