﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "NotificationPlayTimer.h"

#include <nn/util/util_FormatString.h>
#include "../../config/NotificationParameter.h"

namespace scene{ namespace overlay{

    NotificationPlayTimer::NotificationPlayTimer() NN_NOEXCEPT
    {
        typedef config::NotificationStyle Style;

        m_pPanel = std::make_shared<panel::PanelText>();
        m_pPanel->SetPosition(nn::util::Vector3f(0, 0, 0));
        m_pPanel->SetSize(Style::GetSizeF());
        m_pPanel->SetColor(Style::GetBackgroundColor());
        m_pPanel->SetVisibility(panel::PanelVisibility::Visible);

        m_pPanel->SetTextColor(Style::GetPlayTimerTextColor());
        m_pPanel->SetTextPosition(Style::GetPlayTimerTextPositionX(), Style::GetPlayTimerTextPositionY());
        m_pPanel->SetTextSize(Style::GetPlayTimerTextSize());
    }

    std::shared_ptr<panel::IPanel> NotificationPlayTimer::GetPanel() NN_NOEXCEPT
    {
        return m_pPanel;
    }

    void NotificationPlayTimer::ReadyToAppear() NN_NOEXCEPT
    {
    }

    bool NotificationPlayTimer::SetupLowPlayTimer(int remainTimeSeconds) NN_NOEXCEPT
    {
        // 5 分単位に丸める
        int timeMinutes = ((remainTimeSeconds + 150) / 300) * 5;
        char msg[256] = "";
        nn::util::SNPrintf(msg, sizeof(msg), "PlayTimer %d more minutes", timeMinutes);
        m_pPanel->SetText(msg);

        m_TimeToLive = config::NotificationTtl::GetTtlPlayTimerLimitComing();
        m_Category   = NotificationCategory_Condition;
        m_Priority   = config::ConditionPriority_PlayTimerLimitComing;
        return true;
    }

    bool NotificationPlayTimer::SetupZeroPlayTimerAlarm() NN_NOEXCEPT
    {
        m_pPanel->SetText("PlayTimer Out of time");

        m_TimeToLive = config::NotificationTtl::GetTtlPlayTimerLimitReached();
        m_Category   = NotificationCategory_Condition;
        m_Priority   = config::ConditionPriority_PlayTimerLimitReachedAlarm;
        return true;
    }

    bool NotificationPlayTimer::SetupZeroPlayTimerStop() NN_NOEXCEPT
    {
        m_pPanel->SetText("PlayTimer Out of time");

        m_TimeToLive = config::NotificationTtl::GetTtlPlayTimerLimitReached();
        m_Category   = NotificationCategory_Condition;
        m_Priority   = config::ConditionPriority_PlayTimerLimitReachedStop;
        return true;
    }

    bool NotificationPlayTimer::SetupExceededPlayTimer(int exceededTimeSeconds) NN_NOEXCEPT
    {
        // 5 分単位に丸める
        int timeMinutes = ((exceededTimeSeconds + 150) / 300) * 5;
        char msg[256] = "";
        nn::util::SNPrintf(msg, sizeof(msg), "PlayTimer %d minutes over", timeMinutes);
        m_pPanel->SetText(msg);

        m_TimeToLive = config::NotificationTtl::GetTtlPlayTimerLimitOver();
        m_Category   = NotificationCategory_Condition;
        m_Priority   = config::ConditionPriority_PlayTimerLimitOver;
        return true;
    }
}}
