﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "NotificationHomeProhibited.h"

#include "../../config/NotificationParameter.h"

namespace scene{ namespace overlay{

    NotificationHomeProhibited::NotificationHomeProhibited(bool isLongPressed) NN_NOEXCEPT
        : m_IsLongPressed(isLongPressed)
    {
        typedef config::NotificationStyle Style;

        m_pPanel = std::make_shared<panel::PanelText>();
        m_pPanel->SetPosition(nn::util::Vector3f(0, 0, 0));
        m_pPanel->SetSize(Style::GetSizeF());
        m_pPanel->SetColor(Style::GetBackgroundColor());
        m_pPanel->SetVisibility(panel::PanelVisibility::Visible);

        m_pPanel->SetTextColor(Style::GetHomeProhibitedTextColor());
        m_pPanel->SetTextPosition(Style::GetHomeProhibitedTextPositionX(), Style::GetHomeProhibitedTextPositionY());
        m_pPanel->SetTextSize(Style::GetHomeProhibitedTextSize());
    }

    std::shared_ptr<panel::IPanel> NotificationHomeProhibited::GetPanel() NN_NOEXCEPT
    {
        return m_pPanel;
    }

    void NotificationHomeProhibited::ReadyToAppear() NN_NOEXCEPT
    {
    }

    bool NotificationHomeProhibited::SetupHomeProhibited() NN_NOEXCEPT
    {
        m_pPanel->SetText(m_IsLongPressed ? "QuickSettings is prohibited" : "HomeButton is prohibited");

        m_TimeToLive = config::NotificationTtl::GetTtlHomeButtonProhibited();
        m_Category   = NotificationCategory_HomeProhibited;
        m_Priority   = 0;
        return true;
    }

}}
