﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "NotificationAccount.h"

#include <nn/account/account_Api.h>
#include <nn/util/util_FormatString.h>
#include "../../config/NotificationParameter.h"

namespace scene{ namespace overlay{
namespace {
const char* GetAccountUserStateChangeKindName(nn::ovln::format::AccountUserStateChangeKind kind) NN_NOEXCEPT
{
    switch (kind)
    {
    case nn::ovln::format::AccountUserStateChangeKind::Opened:
        return "opened";
    case nn::ovln::format::AccountUserStateChangeKind::Closed:
        return "closed";
    default:
        return "";
    }
}
}

NotificationAccount::NotificationAccount() NN_NOEXCEPT
{
    typedef config::NotificationStyle Style;

    m_pPanel = std::make_shared<panel::PanelText>();
    m_pPanel->SetPosition(nn::util::Vector3f(0, 0, 0));
    m_pPanel->SetSize(Style::GetSizeF());
    m_pPanel->SetColor(Style::GetBackgroundColor());
    m_pPanel->SetVisibility(panel::PanelVisibility::Visible);

    m_pPanel->SetTextColor(Style::GetAccountTextColor());
    m_pPanel->SetTextPosition(Style::GetAccountTextPositionX(), Style::GetAccountTextPositionY());
    m_pPanel->SetTextSize(Style::GetAccountTextSize());
}

std::shared_ptr<panel::IPanel> NotificationAccount::GetPanel() NN_NOEXCEPT
{
    return m_pPanel;
}

void NotificationAccount::ReadyToAppear() NN_NOEXCEPT
{
}

bool NotificationAccount::Setup(const nn::ovln::format::AccountUserStateChangeData& data) NN_NOEXCEPT
{
    nn::account::Nickname nickname;
    auto r = nn::account::GetNickname(&nickname, data.uid);
    if (!r.IsSuccess())
    {
        nickname.name[0] = '\0';
    }

    char str[128];
    nn::util::SNPrintf(
        str, sizeof(str),
        "User %s\n"
        "\"\"%s\"",
        GetAccountUserStateChangeKindName(data.kind), nickname.name);
    m_pPanel->SetText(str);

    m_TimeToLive = config::NotificationTtl::GetTtlAccount();
    m_Category   = NotificationCategory_Condition;
    m_Priority   = config::ConditionPriority_Account;

    return true;
}

}}
