﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include "SceneMenuPageBase.h"
#include "../debug/debug_Activity.h"
#include "../debug/debug_LayoutEditor.h"
#include "../../ui/ui_IMenuItem.h"
#include "../../config/DebugMenuStyle.h"

namespace scene{ namespace debug{
    class SceneDebug;
}}

namespace scene{ namespace menu{

    class SceneDebugMenuPage
        : public SceneMenuPageBase
    {
        typedef config::DebugMenuStyle StyleType;
    public:
        explicit SceneDebugMenuPage(const std::shared_ptr<void>& arg) NN_NOEXCEPT;

        virtual void OnEnteringPage(const std::shared_ptr<ui::IMenuPage>& pPage) NN_NOEXCEPT NN_OVERRIDE;
        virtual void OnLeavingPage(const std::shared_ptr<ui::IMenuPage>& pPage) NN_NOEXCEPT NN_OVERRIDE;
        virtual void OnClosingPage(const std::shared_ptr<ui::IMenuPage>& pPage) NN_NOEXCEPT NN_OVERRIDE;

    private:
        std::shared_ptr<ui::IMenuItem> MakePageHeaderImpl() NN_NOEXCEPT;
        std::shared_ptr<ui::IMenuItem> MakePageFooterImpl() NN_NOEXCEPT;
        std::shared_ptr<ui::IMenuItem> MakePageBodyImpl() NN_NOEXCEPT;

        std::shared_ptr<ui::IMenuItem> MakePageBodyConfigListImpl() NN_NOEXCEPT;
        std::shared_ptr<ui::IMenuItem> MakePageBodyLayoutEditorImpl() NN_NOEXCEPT;

        void SetupLayoutEditorImpl() NN_NOEXCEPT;

    private:
        // UI 操作で編集中の Activity
        std::shared_ptr<debug::Activity> m_pActivity;
        std::shared_ptr<bool> m_pIsSaveToSdCardRequested;
        std::shared_ptr<debug::LayoutEditor> m_pLayoutEditor;
    };

}}
