﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/util/util_Optional.h>
#include "../../ui/ui.h"
#include "../../AppletMessageThread.h"

namespace scene{ namespace menu{

    class MenuPageReactor
        : public ui::IMenuPage
    {
    public:
        MenuPageReactor() NN_NOEXCEPT;

        virtual void CloseMenu() NN_NOEXCEPT NN_OVERRIDE;
        virtual void ClosePage() NN_NOEXCEPT NN_OVERRIDE;
        virtual void OpenPage(PageIndexType sceneIndex) NN_NOEXCEPT NN_OVERRIDE;
        virtual void OpenPage(PageIndexType sceneIndex, const std::shared_ptr<void>& pUserArgument) NN_NOEXCEPT NN_OVERRIDE;
        virtual void ChangeFocus(const std::shared_ptr<ui::IMenuItem>& newItem) NN_NOEXCEPT NN_OVERRIDE;
        virtual void SleepSystem() NN_NOEXCEPT NN_OVERRIDE;
        virtual void ShutdownSystem() NN_NOEXCEPT NN_OVERRIDE;
        virtual void SendMessage(const AppletMessageMenuResponse& message) NN_NOEXCEPT NN_OVERRIDE;
        virtual void LoadValue() NN_NOEXCEPT NN_OVERRIDE;
        virtual void StoreValue() NN_NOEXCEPT NN_OVERRIDE;
        virtual void UpdateLayout() NN_NOEXCEPT NN_OVERRIDE;
        virtual void UpdatePanel() NN_NOEXCEPT NN_OVERRIDE;
        virtual void SetEnablity(const std::shared_ptr<ui::IMenuItem>& pItem, bool isEnabled) NN_NOEXCEPT NN_OVERRIDE;
        virtual void PushMenuLayerImpl(const std::shared_ptr<ui::IMenuItem>& pItem, const ui::Position& anchor) NN_NOEXCEPT NN_OVERRIDE;
        virtual void PopMenuLayerImpl() NN_NOEXCEPT NN_OVERRIDE;

        bool IsClosePageRequested() const NN_NOEXCEPT;
        bool IsCloseMenuRequested() const NN_NOEXCEPT;
        bool IsLoadValueRequested() const NN_NOEXCEPT;
        bool IsStoreValueRequested() const NN_NOEXCEPT;
        bool IsUpdateLayoutRequested() const NN_NOEXCEPT;
        bool IsUpdatePanelRequested() const NN_NOEXCEPT;
        nn::util::optional<std::pair<PageIndexType, std::shared_ptr<void>>> GetPageOpenRequest() const NN_NOEXCEPT;
        nn::util::optional<std::pair<PageIndexType, std::shared_ptr<void>>> GetLayerPushRequest() const NN_NOEXCEPT;
        nn::util::optional<std::shared_ptr<ui::IMenuItem>> GetFocusChangeRequest() const NN_NOEXCEPT;
        nn::util::optional<AppletMessageMenuResponse> GetAppletResponseRequest() const NN_NOEXCEPT;
        int GetEnablityChangeRequestCount() const NN_NOEXCEPT;
        std::pair<std::shared_ptr<ui::IMenuItem>, bool> GetEnablityChangeRequestEntry(int index) const NN_NOEXCEPT;

    private:
        bool m_IsClosePageRequested = false;
        bool m_IsCloseMenuRequested = false;
        bool m_IsLoadValueRequested = false;
        bool m_IsStoreValueRequested = false;
        bool m_IsUpdateLayoutRequested = false;
        bool m_IsUpdatePanelRequested = false;
        nn::util::optional<std::pair<PageIndexType, std::shared_ptr<void>>> m_PageOpenRequest;
        nn::util::optional<std::pair<PageIndexType, std::shared_ptr<void>>> m_LayerPushRequest;
        nn::util::optional<std::shared_ptr<ui::IMenuItem>> m_FocusChangeRequest;
        nn::util::optional<AppletMessageMenuResponse> m_AppletResponseRequest;
        std::vector<std::pair<std::shared_ptr<ui::IMenuItem>, bool>> m_EnablityChangeRequestList;

    };
}}
