﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

namespace scene{ namespace debug{

    // ログの 1 行あたりの最大サイズ[bytes]。
    static const size_t LogLineSizeMax = 256;

    struct LogLineString
    {
        char value[LogLineSizeMax];
    };

    class ILogStorage
    {
    public:
        virtual ~ILogStorage() NN_NOEXCEPT
        {
        }

        // 現在保存されている行番号の begin と end を返す。 [begin, end)。
        virtual void GetLineRange(uint64_t* pOutLineBegin, uint64_t* pOutLineEnd) NN_NOEXCEPT = 0;

        // 指定された行番号の文字列を取得する。
        // 指定した行番号が保存されていない場合、空文字列を返す。
        // 文字列の長さ(bytes)を返す。
        virtual void GetLineString(LogLineString* pOutValue, uint64_t line) NN_NOEXCEPT = 0;

        virtual void SetAutoLineFeed(
            float lineWidthMax,
            float (*charWidthGetterFunction)(const char*, size_t, void*),
            void* charWidthGetterUserPtr
        ) NN_NOEXCEPT = 0;
    };

}}
