﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "debug_Clock.h"

#include <nn/time.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>
#include <nn/util/util_FormatString.h>
#include <nn/os.h>

namespace scene{ namespace debug{

    Clock::Clock() NN_NOEXCEPT
    {
        m_pContainer = std::make_shared<panel::PanelContainer>();
        m_pPanelText = std::make_shared<panel::PanelText>();

        m_pContainer->AddChild(m_pPanelText);
    }

    std::shared_ptr<panel::IPanel> Clock::GetPanel() NN_NOEXCEPT
    {
        return m_pContainer;
    }

    void Clock::Update() NN_NOEXCEPT
    {
        char buf[64] = "????";

        switch(m_Activity.clockType)
        {
        case ActivityClock::ClockType_SystemClock:
            {
                nn::time::PosixTime posixTime = {};
                if(nn::time::StandardUserSystemClock::GetCurrentTime(&posixTime).IsFailure())
                {
                    break;
                }

                nn::time::CalendarTime calendarTime = {};
                nn::time::CalendarAdditionalInfo calendarInfo = {};
                if(nn::time::ToCalendarTime(&calendarTime, &calendarInfo, posixTime).IsFailure())
                {
                    break;
                }

                nn::util::SNPrintf(buf, sizeof(buf), "%04d/%02d/%02d %02d:%02d:%02d",
                    static_cast<int>(calendarTime.year),
                    static_cast<int>(calendarTime.month),
                    static_cast<int>(calendarTime.day),
                    static_cast<int>(calendarTime.hour),
                    static_cast<int>(calendarTime.minute),
                    static_cast<int>(calendarTime.second)
                );

                break;
            }
        case ActivityClock::ClockType_SystemTick:
            {
                auto tick = nn::os::GetSystemTick();
                nn::util::SNPrintf(buf, sizeof(buf), "%llu", tick);
                break;
            }
        default: ;
        }

        // 描画用オブジェクトを更新
        // 既に設定されているものと同じ値を設定しようとした場合には何もしないので
        // とりあえずは全パラメータを毎回設定してしまってもそうそう問題にはならないはず。
        m_pContainer->SetVisibility(panel::PanelVisibility::Visible);
        m_pContainer->SetColor({0, 0, 0, 1});
        m_pContainer->SetPosition(m_Activity.common.positionX, m_Activity.common.positionY);
        m_pContainer->SetSize(m_Activity.GetWidth(), m_Activity.GetHeight()); // 親のサイズで子の描画範囲が制限されるので設定し忘れると何も表示されない。

        m_pPanelText->SetVisibility(panel::PanelVisibility::Visible);
        m_pPanelText->SetColor({0, 0, 0, 1});
        m_pPanelText->SetPosition(0, 0); // 親の Container 内のローカル座標
        m_pPanelText->SetSize(m_Activity.GetWidth(), m_Activity.GetHeight());
        m_pPanelText->SetText(buf);
        m_pPanelText->SetTextColor({1, 1, 1, 1});
        m_pPanelText->SetTextPosition(4, 0); // PanelText 内のローカル座標
        m_pPanelText->SetTextSize(16);  // FontSize
    }

    void Clock::SetActivity(const ActivityClock& value) NN_NOEXCEPT
    {
        m_Activity = value;
    }

}}

