﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include "debug_ActivityCommon.h"

namespace scene{ namespace debug{

    struct ActivityLogViewer
    {
    public:
        static const bool IsSupported = true;

        int GetWidth() const NN_NOEXCEPT
        {
            if(this->isBackground)
            {
                return 0;
            }
            return this->width;
        }

        int GetHeight() const NN_NOEXCEPT
        {
            if(this->isBackground)
            {
                return 0;
            }
            return this->height;
        }

    public:
        NN_DEVOVL_DEBUGMODULEACTIVITY_COMMON("LogViewer");

        int32_t width  = 950;
        int32_t height = 360;

        uint32_t isBackground = 0;
        float fontSize = 16;
    };

}}
