﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

#include "../ui/ui_StyleTypes.h"

namespace config{

    class PowerMenuStyle
    {
    public:
        const nn::util::Color4f m_BackgroundColor        = {0, 0, 0, .75f};
        const nn::util::Color4f m_BackgroundColorFocused = {.4f, 0, 0, .75f};
        const nn::util::Color4f m_TextColor = {1, 1, 1, 1};

        const float m_TitleTextSize = 32;
        const float m_ItemTextSize  = 24;

        const int               m_MenuTableWidth = 300;
        const int               m_MenuTableBorderWidth = 0;
        const nn::util::Color4f m_MenuTableBorderColor = {1, 0, 0, 1};

        // Header
        const int m_MenuHeaderHeight = 100;

        // Body
        const int m_MenuButtonHeight = 80;


        ui::MenuItemBoxStyle MakeRootBoxStyle() const NN_NOEXCEPT
        {
            auto v = ui::MenuItemBoxStyle()
                .SetSizeStyle(ui::SizeStyle()
                    .SetFixedSize({ScreenWidth, ScreenHeight})
                )
                .SetBackgroundStyle(ui::BackgroundStyle()
                    .SetColor(m_BackgroundColor)
                )
                .SetAlignment(ui::ItemAlignment_MiddleCenter)
            ;
            return v;
        }

        ui::MenuItemTableStyle MakeMenuTableStyle() const NN_NOEXCEPT
        {
            auto v = ui::MenuItemTableStyle()
                .SetBorderStyle(ui::BorderStyle()
                    .SetColor(m_MenuTableBorderColor)
                    .SetOuterWidth(m_MenuTableBorderWidth)
                    .SetInnerWidth(m_MenuTableBorderWidth)
                )
                .SetDefaultCellStyle(MakeButtonCellStyle())
            ;
            return v;
        }

        // Header

        ui::MenuItemTableCellStyle MakeHeaderCellStyle() const NN_NOEXCEPT
        {
            return ui::MenuItemTableCellStyle()
                .SetAlignment(ui::ItemAlignment_MiddleLeft)
                .SetBackgroundStyle(ui::BackgroundStyle()
                    .SetColor(m_BackgroundColor)
                )
                .SetMargin({0, 0, 0, 4})
                .SetSizeStyle(ui::SizeStyle()
                    .SetAutoSize({m_MenuTableWidth, m_MenuHeaderHeight})
                )
            ;
        }

        ui::MenuItemLabelStyle MakeTitleStyle() const NN_NOEXCEPT
        {
            auto v = ui::MenuItemLabelStyle()
                //.SetSize({300, 100, 0})
                .SetBackgroundColor(ui::ItemStateFilter_Any, m_BackgroundColor)
                .SetTextStyle(ui::ItemStateFilter_Any, ui::TextStyle()
                    .SetFontColor(m_TextColor)
                    .SetFontSize(m_TitleTextSize)
                )
            ;
            return v;
        }

        // Body

        ui::MenuItemTableCellStyle MakeButtonCellStyle() const NN_NOEXCEPT
        {
            return ui::MenuItemTableCellStyle()
                .SetAlignment(ui::ItemAlignment_MiddleLeft)
                .SetBackgroundStyle(ui::BackgroundStyle()
                    .SetMode(ui::BackgroundMode_InnerItem)
                )
                .SetMargin({0, 0, 0, 40})
                .SetSizeStyle(ui::SizeStyle()
                    .SetAutoSize({m_MenuTableWidth, m_MenuButtonHeight})
                )
            ;
        }

        ui::MenuItemLabelStyle MakeButtonStyle() const NN_NOEXCEPT
        {
            auto v = ui::MenuItemLabelStyle()
                .SetBackgroundColor(ui::ItemStateFilter_Any, m_BackgroundColor)
                .SetBackgroundColor(ui::ItemStateFilter_InFocus, m_BackgroundColorFocused)
                .SetTextStyle(ui::ItemStateFilter_Any, ui::TextStyle()
                    .SetFontColor(m_TextColor)
                    .SetFontSize(m_ItemTextSize)
                )
            ;
            return v;
        }
    };

}
