﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

class RunMode
{
public:
    void Initialize() NN_NOEXCEPT;

    bool IsExhibitionMode() const NN_NOEXCEPT;

    // 通知の表示設定
    bool IsChargerStateChangeDisplayed() const NN_NOEXCEPT;
    bool IsAudioVolumeChangeDisplayed() const NN_NOEXCEPT;
    bool IsScreenShotNotificationDisplayed() const NN_NOEXCEPT;
    bool IsMovieNotificationDisplayed() const NN_NOEXCEPT;
    bool IsHomeButtonProhibitionDisplayed() const NN_NOEXCEPT;
    bool IsLowBatteryNotificationDisplayed() const NN_NOEXCEPT;
    bool IsControllerPairingDisplayed() const NN_NOEXCEPT;
    bool IsControllerLowBatteryDisplayed() const NN_NOEXCEPT;
    bool IsControllerDisconnectionDisplayed() const NN_NOEXCEPT;
    bool IsPctlRemainingTimeDisplayed() const NN_NOEXCEPT;
    bool IsPctlSettingChangedDisplayed() const NN_NOEXCEPT;
    bool IsDownloadCompletionDisplayed() const NN_NOEXCEPT;
    bool IsContentAvailableDisplayed() const NN_NOEXCEPT;
    bool IsFriendNotificationDisplayed() const NN_NOEXCEPT;
    bool IsServerMaintenanceScheduledDisplayed() const NN_NOEXCEPT;
    bool IsServerMaintenanceStartDisplayed() const NN_NOEXCEPT;
    bool IsAccountDisplayed() const NN_NOEXCEPT;
    bool IsSnapShotDumperProgressDisplayed() const NN_NOEXCEPT;

    // 通知の SE 再生設定
    bool IsNotificationSoundEffectEnabled() const NN_NOEXCEPT;

public:
    bool m_IsExhibitionMode;
};
