﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "DevMenu_SaveData.h"
#include "DevMenu_SaveDataUiPolicy.h"
#include "../Common/DevMenu_CommonScrollBox.h"
#include "../DevMenu_Common.h"

#include <atomic>
#include <string>
#include <glv_ScissorBoxView.h>
#include <glv/detail/glv_GfxTextApi.h>

#include <nn/nn_Common.h>
#include <nn/ncm/ncm_ContentMetaDatabase.h>
#include <nn/ns/ns_ApplicationManagerApi.h>

namespace devmenu { namespace savedata {

/** DetailScene ---------------------------------------------------------------------
 */
class DetailScene : public SaveDataSceneBase
{
public:
    DetailScene( const AbstractOperators& op, Page* pParentPage, const glv::Rect& rect, const std::function< void() >& backButtonCallback ) NN_NOEXCEPT;
    ~DetailScene() NN_NOEXCEPT;

    glv::View* GetPrimaryView() NN_NOEXCEPT;

    SceneType GetParentScene() NN_NOEXCEPT;

    void SetParentScene( SceneType parentScene ) NN_NOEXCEPT { m_ParentScene = parentScene; };
    void UpdateDetails( const SaveDataPropertyType* const pSaveDataProperty ) NN_NOEXCEPT;

    void Clear() NN_NOEXCEPT;
    void Refresh() NN_NOEXCEPT;

private:
    /** Buttons ---------------------------------------------------------------------
    */
    class ButtonsTop : public glv::View
    {
    public:
        ButtonsTop( const AbstractOperators& op, DetailScene& parent, const glv::Rect& rect ) NN_NOEXCEPT;
        void Clear() NN_NOEXCEPT;
        void Update() NN_NOEXCEPT;
        glv::View& GetBackButton() NN_NOEXCEPT { return m_BackButton; }

    private:
        static const glv::Rect CloseButtonRect;

    private:
        const AbstractOperators& m_Op;
        DetailScene&             m_Parent;
        glv::Table               m_Table;
        devmenu::Button          m_BackButton;
    };

    class IconButtons : public glv::View
    {
    public:
        IconButtons( const AbstractOperators& op, DetailScene& parent, const glv::Rect& rect ) NN_NOEXCEPT;
        void Clear() NN_NOEXCEPT;
        void Update() NN_NOEXCEPT;
        void UpdateApplicationIcon( const devmenu::Buffer& iconBuffer ) NN_NOEXCEPT;
        void ClearApplicationIcon() NN_NOEXCEPT;

    private:
        static const glv::Rect ExportButtonRect;
        static const glv::Rect VerifyButtonRect;
        static const glv::Rect DeleteButtonRect;
        static const glv::Rect CorruptButtonRect;
        static const glv::Rect ExportRawButtonRect;

    private:
        const AbstractOperators& m_Op;
        DetailScene&             m_Parent;
        devmenu::Button          m_ExportButton;
        devmenu::Button          m_VerifyButton;
        devmenu::Button          m_DeleteButton;
        devmenu::Button          m_CorruptButton;
        devmenu::Button          m_ExportRawButton;
        glv::Table               m_Table;
        ApplicationIcon          m_Icon;
    };

    /** Detail ---------------------------------------------------------------------
    */
    class Detail : public glv::View
    {
    public:
        enum LabelTypesApplicationInfo
        {
            LabelTypesApplicationInfo_ApplicationTitle,
            LabelTypesApplicationInfo_ApplicationId,

            LabelTypesApplicationInfo_NumElements
        };

        enum LabelTypesSaveDataInfo
        {
            LabelTypesSaveDataInfo_SaveDataId,
            LabelTypesSaveDataInfo_SaveDataOwnerId,
            LabelTypesSaveDataInfo_SaveDataType,
            LabelTypesSaveDataInfo_AvailableSize,
            LabelTypesSaveDataInfo_JournalSize,
#if defined( NN_DEVMENUSYSTEM )
            LabelTypesSaveDataInfo_SystemSaveDataId,
            LabelTypesSaveDataInfo_Flag,
#endif
            LabelTypesSaveDataInfo_NumElements
        };

    public:
        Detail( DetailScene& parent, const glv::Rect& rect ) NN_NOEXCEPT;
        virtual ~Detail() NN_NOEXCEPT;

        void SetLabelInfo() NN_NOEXCEPT;

        void Clear() NN_NOEXCEPT;
        void Update() NN_NOEXCEPT;

        void EnableCorruptWarning( bool isEnabled ) NN_NOEXCEPT;

    public:
        glv::WideString stringsApplicationInfoField[ LabelTypesApplicationInfo_NumElements ];
        glv::WideString stringsSaveDataInfoField[ LabelTypesSaveDataInfo_NumElements ];

    private:
        static const glv::Label::Spec DefalutLabelSpec;
        static const glv::Label::Spec InfoLabelSpecDefault;
        static const glv::Label::Spec InfoLabelSpecMinimum;

        static const glv::Rect ScrollRect;

    private:
        DetailScene& m_Parent;

        ScrollableBoxView m_ScrollableContainer;
        glv::Table  m_BaseTable;
        glv::Table  m_SaveDataHeader;
        glv::Table  m_SaveDataInfo;
        glv::Table  m_ApplicationInfo;

        glv::Label* m_pLabelApplicationInfoTitle[ LabelTypesApplicationInfo_NumElements ];
        glv::Label* m_pLabelApplicationInfoField[ LabelTypesApplicationInfo_NumElements ];
        glv::Label* m_pLabelSaveDataInfoTitle[ LabelTypesSaveDataInfo_NumElements ];
        glv::Label* m_pLabelSaveDataInfoField[ LabelTypesSaveDataInfo_NumElements ];

        glv::Label   m_LabelApplicationInfoHeader;
        glv::Label   m_LabelSaveDataInfoHeader;
        glv::Label   m_LabelCorruptedSaveData;
        glv::Style   m_StyleHeader;
        glv::Divider m_DividerMetadataInfoHeader;
        glv::Divider m_DividerApplicationInfoHeader;
    };

private:
    glv::Table          m_Base;
    Detail              m_Detail;
    ButtonsTop          m_ButtonsTop;
    IconButtons         m_IconButtons;
    SceneType           m_ParentScene;
};

}} // ~namespace devmenu::savedata, ~namespace devmenu

