﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/time/time_ApiForMenu.h>
#include <nn/time/time_StandardLocalSystemClockPrivilegeApi.h>

#include "DevMenu_DeviceSettingsSceneType.h"
#include "DevMenu_DeviceSettingsTimeZoneSelectorScene.h"
#include "DevMenuCommand_TimeZone.h"

namespace devmenu { namespace devicesettings { namespace tzselect {

TimeZoneSelectorScene::TimeZoneSelectorScene( Page* pPage, const glv::Rect& rect, const std::function< void() >& closeCallback ) NN_NOEXCEPT
    : Scene( pPage, rect, false, closeCallback )
    , m_ScrollableContainer( "<, <, d", rect, 10.0f )
    , m_BackButton( "< Back"
        , [&] { this->OnBackButtonPressed(); }
        , glv::Rect( this->width() / 2, CommonValue::InitialFontSize * 2 ), glv::Place::CC )
{
    this->SetFirstFocusTargetView( &m_BackButton );

    // タイムゾーン選択ボタンの用意
    auto pTimeZoneList = devmenuUtil::GetTimeZoneList();
    const int count = devmenuUtil::GetCountOfTimeZone();
    for ( int i = 0 ; i < count ; ++i )
    {
        auto& locationName = pTimeZoneList[ i ].locationName;
        auto* pTimeZoneSelectionButton = new TimeZoneSelectionButton(
            pTimeZoneList[ i ].displayString,
            [ this, locationName ]() {
                nn::time::SetDeviceLocationName( locationName );
                this->SwitchScene( SceneType_ItemList, true );
            },
            glv::Rect( this->width() * 0.9, CommonValue::InitialFontSize * 2 ),
            glv::Place::CC );
        m_ScrollableContainer << pTimeZoneSelectionButton;
    }

    auto pFooter = new glv::Label( GLV_TEXT_API_WIDE_STRING( "↑↓:Focus  A:Select  B:Back" ),
        glv::Label::Spec( glv::Place::BR, 0.0f, 0.0f, CommonValue::InitialFontSize ) );

    m_ScrollableContainer.SetRectAndUpdateInnerSize( width(), height() - m_BackButton.height() - pFooter->height() - 20.0f );
    m_ScrollableContainer.ArrangeTable();

    auto pTable = new glv::Table( "<", 3.0f, 10.0f );
    *pTable << m_BackButton << m_ScrollableContainer;
    pTable->arrange();
    *this << pTable << pFooter;

    this->disable( glv::Property::Visible ); // 非表示が初期状態
}

}}} // ~namespace devmenu::tzselect, ~namespace devmenu

