﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <vector>
#include "DevMenu_DeviceSettingsCommon.h"

namespace devmenu { namespace devicesettings {

glv::Table* Subsection::CreateCategoryHeader( const char* text, const glv::Label::Spec& spec, const glv::Rect& rect ) NN_NOEXCEPT
{
    // Header style
    static glv::Style s_HeaderStyle;
    s_HeaderStyle.color.text.set( 0.6f, 0.6f, 0.6f );
    auto pHeader = new glv::Table( "<", 0.0f, 0.0f, rect );
    auto pTitle = new glv::Label( text, spec );
    auto pDivider = new glv::Divider( 10.0f, 2.0f );

    pTitle->style( &s_HeaderStyle );
    *pHeader << pTitle << pDivider;
    pHeader->arrange();
    return pHeader;
}

Subsection::Subsection( Page* pPage, const char* headerText, glv::space_t width ) NN_NOEXCEPT
    : glv::Table( "<", 3.0f, 10.0f )
{
    *this << CreateCategoryHeader( headerText, HeaderLabelSpec, glv::Rect( width - RightPadding , 50.0f ) );
    arrange();
    disable( glv::Property::Controllable | glv::Property::DrawBack | glv::Property::DrawBorder | glv::Property::HitTest );
}

const glv::Label::Spec Subsection::HeaderLabelSpec = glv::Label::Spec( glv::Place::TL, 0.0f, 0.0f, CommonValue::InitialFontSize );

SubsectionWithFocusUtility::SubsectionWithFocusUtility( Page* pPage, const char* headerText, glv::space_t width ) NN_NOEXCEPT
    : Subsection( pPage, headerText, width )
{
}

}} // ~namespace devmenu::devicesettings, ~namespace devmenu
