﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace devmenu {

struct OwnSaveData
{
    bool skipsBrightnessSensorBrokenMessage;
    nn::Bit8 reserved[ 511 ];
};

static_assert( sizeof( OwnSaveData ) == 512, "sizeof( OwnSaveData ) must be 512." );

/**
 * @brief       DevMenu のセーブデータを確認します。
 *
 * @details     セーブデータが存在する場合は真を返します。存在しない場合はセーブデータを作成して偽を返します。
 */
bool CheckSaveData() NN_NOEXCEPT;

nn::Result ReadSaveData( OwnSaveData* pOutData ) NN_NOEXCEPT;
nn::Result WriteSaveData( const OwnSaveData* pData ) NN_NOEXCEPT;

} // ~namespace devmenu
