﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/ncm/ncm_ContentMetaDatabase.h>

#if defined (NN_DEVMENU_ENABLE_SYSTEM_APPLET)

namespace devmenu { namespace exhibition {

enum CancelCommandType : nn::Bit8
{
    CancelCommandType_Default,
    CancelCommandType_Internal,
    CancelCommandType_Licensee,
    CancelCommandType_Unknown, // Unknown 以降が万が一にでも設定されていたら Default 扱いにする
};

struct ExhibitionSaveData
{
    char applicationIdString[ 32 ];
    CancelCommandType commandType;
    nn::Bit8 reserved[ 95 ];
};

/**
 * @brief    exhibition mode か否かを判別します。
 */
bool IsExhibitionModeEnabled() NN_NOEXCEPT;

/**
 * @brief  exhibition mode 向けのセーブデータファイルを削除します。
 */
nn::Result DeleteSaveData() NN_NOEXCEPT;

/**
 * @brief  自動起動するアプリケーションの ApplicationId をセーブデータに保存します。
 */
nn::Result SetAutoBootApplicationId( const char* applicationIdStr ) NN_NOEXCEPT;

/**
 * @brief  自動起動に失敗した理由に対応したエラーメッセージを取得します。
 */
const std::string GetLaunchErrorMessage( nn::Result result, int64_t requiredSize = 0LL ) NN_NOEXCEPT;

class AutoBootExecutor
{
    static const int64_t CancelCommandInputTime = 3000;  // キャンセルコマンドの受付時間, 単位は milli seconds

public:
    AutoBootExecutor() NN_NOEXCEPT;

    CancelCommandType GetCancelCommandType() NN_NOEXCEPT;

    void UpdateCancelCommand( CancelCommandType type ) NN_NOEXCEPT;

    bool IsAutoBootExecutable() NN_NOEXCEPT;

    bool CancelAutoBoot( bool isForced = false ) NN_NOEXCEPT;

    nn::Result Launch() NN_NOEXCEPT;

private:
    bool CanReceiveCancelCommand() NN_NOEXCEPT;

    bool               m_IsAutoBootDisabled;
    bool               m_CanReceiveCancelCommand;
    ExhibitionSaveData m_SaveData;
};

}} // ~namespace devmenu::exhibition, ~namespace devmenu

#endif // defined (NN_DEVMENU_ENABLE_SYSTEM_APPLET)
