﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <nn/nn_Abort.h>
#include <nn/time.h>
#include "DevMenu_DateTime.h"

/**
 * @brief       日時のユーティリティの定義です。
 */
namespace devmenu {

void FromPosixTime(
    DateTime& outDateTime,
    int64_t inPosixSecond) NN_NOEXCEPT
{
    nn::time::PosixTime posix = {inPosixSecond};
    nn::time::CalendarTime c;
    NN_ABORT_UNLESS_RESULT_SUCCESS(nn::time::ToCalendarTime(&c, nullptr, posix));

    outDateTime.year = c.year;
    outDateTime.month = c.month;
    outDateTime.day = c.day;
    outDateTime.hour = c.hour;
    outDateTime.minute = c.minute;
    outDateTime.second = c.second;
}

int64_t GetPosixTime() NN_NOEXCEPT
{
    nn::time::PosixTime posix;
    NN_ABORT_UNLESS_RESULT_SUCCESS(nn::time::StandardUserSystemClock::GetCurrentTime(&posix));
    return posix.value;
}

} // end of namespace devmenu
