﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "DevMenu_CommonIconLabel.h"
#include "../siglo/engineOnGfx/source/GfxRuntimeEngine-private.h"

namespace devmenu {

IconLabel::IconLabel( const glv::WideCharacterType* text, const glv::Label::Spec& spec ) NN_NOEXCEPT
    : glv::Label( text, spec )
{
    auto& applicationContext = glv::detail::GetGlvRuntimeEngine().GetApplicationContext();

    // Update the GfxContext to enable printing of the Icon Font
    applicationContext.GetFrameContext().GetGfxContext()->EnableIconFont( true );
    m_Text = text;

    // Recalculate the Label's construction with the context for the icon font enabled
    AssistStandardConstruction( m_Text, spec.stroke, spec.vert );
    size( spec.size );
    pos( spec.posAnch, spec.dx, spec.dy ).anchor( spec.posAnch );

    // Update the GfxContext to disable printing of the Icon Font
    applicationContext.GetFrameContext().GetGfxContext()->EnableIconFont( false );
}

void IconLabel::onDraw( glv::GLV& glvRoot ) NN_NOEXCEPT
{
    // Get Context and prepare the texture descriptor to print the font
    auto& applicationContext = glv::detail::GetGlvRuntimeEngine().GetApplicationContext();

    // Get the frame context
    glv::detail::GfxFrameContext& frameContext = applicationContext.GetFrameContext();

    // Update the GfxContext to enable printing of the Icon Font
    frameContext.GetGfxContext()->EnableIconFont( true );

    // Code borrowed from glv_textview.cpp: Label::onDraw(GLV& g)
    glv::draw::lineWidth( stroke() );

    if ( m_IsEnabled )
    {
        // Use the current styles text color
        glv::draw::color( colors().text );
    }
    else
    {
        // Display icon in a gray color
        glv::draw::color( 0.3f, 1.0f );
    }

    // Render the font
    font().render( m_Text, 0.0f, 0.0f, 0.0f );

    // Update the GfxContext to disable printing of the Icon Font
    frameContext.GetGfxContext()->EnableIconFont( false );
}

void IconLabel::UpdateStyle( bool isEnabled ) NN_NOEXCEPT
{
    m_IsEnabled = isEnabled;
}

void IconLabel::SetValue( const glv::WideCharacterType* text ) NN_NOEXCEPT
{
    m_Text = text;
}

const glv::WideCharacterType* IconCodePoint::ArrowUp = u"\uf0aa";
const glv::WideCharacterType* IconCodePoint::ArrowDown = u"\uf0ab";
const glv::WideCharacterType* IconCodePoint::Check = u"\uf00c";
const glv::WideCharacterType* IconCodePoint::ControllerButtonFilledHome = u"\ue926";
const glv::WideCharacterType* IconCodePoint::ControllerButtonFilledX = u"\ue90c";
const glv::WideCharacterType* IconCodePoint::GameCard = u"\ue95e";
const glv::WideCharacterType* IconCodePoint::GameCardMissing = u"\ue964";
const glv::WideCharacterType* IconCodePoint::Power = u"\ue962";
const glv::WideCharacterType* IconCodePoint::SaveData = u"\uf0c7";
const glv::WideCharacterType* IconCodePoint::CircleO = u"\uf10c";
const glv::WideCharacterType* IconCodePoint::DotCircleO = u"\uf192";
const glv::WideCharacterType* IconCodePoint::Warning = u"\uf071";

} // ~namespace devmenu
