﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "DevMenu_CommonDropDown.h"
#include "DevMenu_CommonFocusManager.h"

namespace devmenu {

void FocusManager::Clear() NN_NOEXCEPT
{
    m_FocusSwitchList.clear();
}

bool FocusManager::onEvent(glv::View& view, glv::GLV& glvRoot) NN_NOEXCEPT
{
    for (const auto& focusSwitch : m_FocusSwitchList)
    {
        const auto className = std::string(view.className());
        if (className == "DevMenuDropDown")
        {
            auto pDropDown = static_cast< DropDownBase* >(&view);
            if (pDropDown->IsShowingList())
            {
                return true;
            }
        }

        if (focusSwitch.pPreviousView == &view)
        {
            const auto eventType = glvRoot.eventType();
            const bool needsFocusSwitch = (
                (eventType == glv::Event::BasicPadDown || eventType == glv::Event::BasicPadRepeat) && glvRoot.getBasicPadEvent().GetButtons().Test(focusSwitch.basicButtonIndex)) ||
                ((eventType == glv::Event::DebugPadDown || eventType == glv::Event::DebugPadRepeat) && glvRoot.getDebugPadEvent().GetButtons().Test(focusSwitch.debugButtonIndex));

            if (!needsFocusSwitch)
            {
                continue;
            }

            if (nullptr == focusSwitch.pNextView)
            {
                return false;
            }

            glvRoot.setFocus(focusSwitch.pNextView);
            return false;
        }
    }
    return true;
}

} // ~namespace devmenu
